classdef (SharedTestFixtures={meq_simulink_fixture}) slxmodels_test < meq_test
% Test properties of simulink .slx models
% using Simulink model advisor
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

properties (TestParameter)
  model = {'liusim'}
end

methods(Test, TestTags={'Simulink','SLX-checks'})
  function modeladvisor_checks(testCase,model) 
    %%
    open_system(model);
    fprintf('\nRunning model advisor checks for %s\n',model);
    ma = Simulink.ModelAdvisor.getModelAdvisor(model);
    ma.deselectCheckAll; ma.deselectCheckForTaskAll;
    ma.selectCheckForTask('_SYSTEM_By Task_Model Referencing');
    ma.selectCheckForTask('_SYSTEM_By Task_Managing Library Links and Variants');
    ma.selectCheckForTask('_SYSTEM_By Task_ModelingUsingBuses');
    ma.selectCheckForTask('_SYSTEM_By Task_File Integrity');
    
    checkedTasks = ma.getSelectedCheckForTask;
    ma.runCheck(checkedTasks);
    checkResultStatus = ma.getCheckResultStatus(checkedTasks); 
    
    if ~all(cell2mat(checkResultStatus))
      failStr = '';
      ifail = find(cell2mat(checkResultStatus));
      for ii=1:numel(ifail)
        failStr = [failStr,...
          sprintf('Failed Model Advisor Check: %s\n',checkedTasks{ifail(ii)})]; %#ok<AGROW>
      end
      testCase.verifyFail(failStr);
    end
    %%
    close_system(model,0);

  end
end

end
