classdef meqinterp_test < meq_test
  % Test for meqinterp.m
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  properties (TestParameter)
    method = {'nearest','linear'};
  end
  
  methods(Test,TestTags={'Unit'})
    function test_ND_interp(testCase,method)
      %%
      t = 0:1e-2:0.1;
      nt = numel(t);
      m = 4;
      n = 3;
      LY = struct('t',t,...
        'field0D',rand(1,nt),...
        'field1D',rand(m,nt),...
        'field2D',rand(m,n,nt));
      
      t_interp = 0:1e-3:0.1;
      LX = meqinterp(LY,t_interp,method);
      
      [~,~,it] = intersect(t,t_interp); % find common time indices
      
      % assert equal on common time points
      testCase.assertEqual(meqxk(LX,it),LY);
      
    end
  end
  
end