classdef meqgtcv_test < meq_test
  % test for meqgtcv
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  methods(TestClassSetup)
    function connect_to_tcvdata(testCase)
      server = 'tcvdata.epfl.ch';
      status = mdsconnect(server);
      testCase.assertTrue(isodd(status),'mdsconnect to tcvdata.epfl.ch failed');
    end
  end

  properties(TestParameter)
    static={1,2,3,4,5,6,7}
  end
  
  methods(Test, TestTags = {'TCV'})
    function test_tcv_static(testCase,static)
      % Checks ability to change TCV static tree version
      
      L = fbt('tcv',100000,[],'static',static);

      mdsopen('static',static);
      % meq limiter is a subsampled version of the "t" static system
      diml = cellstr(num2str((1:512/L.G.nl:512)','%03d'  ));
      rl = mdsvalue('static("r_t")[$1]',diml);
      zl = mdsvalue('static("z_t")[$1]',diml);

      testCase.verifyEqual(L.G.rl,rl,sprintf('Mismatch between L.G.rl and data from static tree for static=%d',static));
      testCase.verifyEqual(L.G.zl,zl,sprintf('Mismatch between L.G.zl and data from static tree for static=%d',static));
    end
  end
  
end
