classdef meq_toolbox_checks < meq_test
  % Generic toolbox-level checks
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  methods(Test,TestTags = {'Unit'})
    function test_version(testCase)
      % Check that toolbox version and release date from Contents.m matches CHANGELOG information
      testCase.assumeFalse(verLessThan('matlab','9.6'),'Skip version test for matlab<9.6')
      % Get from Contents.m using ver()
      meqpath = fullfile(fileparts(mfilename('fullpath')),'..');
      v = ver(meqpath);
      testCase.assertNotEmpty(v,'could not get version information for meq toolbox')
      
      % Get from CHANGELOG.md by parsing
      str = fileread('CHANGELOG.md');
      tokens = regexp(str,'## \[(\d+\.\d+\.\d+)\] \- (\d*\-\d*\-\d*)','tokens'); 
      logvers=tokens{1}{1}; logdate=tokens{1}{2};
      
      % Assert that versions are the same
      testCase.assertEqual(v.Version,logvers,...
        sprintf('CHANGELOG.md last version %s does not match Contents.m version %s',logvers,v.Version));
    
      % Assert that dates are the same
      dateconvert = datestr(v.Date,'yyyy-mm-dd'); % convert into same format
      testCase.assertEqual(dateconvert,logdate,...
        sprintf('CHANGELOG.md release date %s does not match Contents.m date %s',logdate,dateconvert));
    end    
  end
end