classdef fgstcv_test < meq_test
  % Tests of Static Forward-Grad-Shafranov solver FGS
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  properties
    tok = 'tcv'
    dosave = false;
    verbosity = 0;
    insrc
    algoNL
    usepreconditioner
    LXliu
    LXfbt
  end
  
  properties(TestParameter)
    src = {'liu','fbt'}; % data sources for fgs
    method = {'all-nl','Picard'};
  end
  
  properties(ClassSetupParameter)
    shot = struct('diverted',61400,'limited',65000,'snowflake',       65270);
    t    = struct('diverted',  0.4,'limited',    1,'snowflake',0.4:0.05:0.7);
  end
  
  methods(TestClassSetup, ParameterCombination='sequential')
    function get_LLX(testCase,shot,t)
      % get L, LX structures from tree, or from file
      tok = testCase.tok; %#ok<*PROPLC>

      fprintf('Setting up test for tok:%s shot:%d t1=%f\n',tok,shot,t(1));

      bfct = @bf3pmex; bfp = [];
      args = {'bfct',bfct,'bfp',bfp};
      
      [~,testCase.LXliu] = fgs(tok,shot,t,'insrc','liu',args{:});
      [~,testCase.LXfbt] = fgs(tok,shot,t,'insrc','fbt',args{:});

    end
  end
  
  methods(Test,TestTags={'fgs'})
    
    function test_fgs(testCase,src,method)

      switch src
        case 'liu', LX = testCase.LXliu;
        case 'fbt', LX = testCase.LXfbt;
        otherwise, error('Catastrophic error');
      end

      tok = testCase.tok;
      bfct = @bf3pmex; bfp = [];
      insrc = src;
      algoNL = method;
      if ~isequal(method,'Picard')
        usepreconditioner = true;
        icsint = false;
        ilim = 1;
      else
        usepreconditioner = false;
        icsint = true;
        ilim = 3;
      end
      
      L = fgs(tok,LX.shot(1),LX.t(1),'debug',testCase.verbosity,...
        'insrc',insrc,'bfct',bfct,'bfp',bfp,'algoNL',algoNL,...
        'usepreconditioner',usepreconditioner,'icsint',icsint,'ilim',ilim);
      LX = fgsx(L,LX);

      LY = fgst(L,LX);
      testCase.verifyTrue(all(LY.isconverged),'did not converge');
    end
    
  end
end
