classdef fgetcv_test < meq_test
  % Tests of FGE for TCV  
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  properties
    tok  = 'tcv';
    shot = 65668;
    t    = 0.2;
  end
  
  properties (TestParameter)
    insrc = struct('insrc_liu', 'liu', 'insrc_fbt', 'fbt', 'insrc_mag', 'mag', 'selu_20', 'liu', 'selu_1', 'liu');
    selu  = struct('insrc_liu', 'v',   'insrc_fbt', 'v',   'insrc_mag', 'v'  , 'selu_20', 'e'  , 'selu_1', 'e'  );
    nu    = struct('insrc_liu', 256,   'insrc_fbt', 256,   'insrc_mag', 256  , 'selu_20', 20   , 'selu_1', 1    );
  end
  
  methods (Test, TestTags = {'TCV'}, ParameterCombination = 'sequential')
    
    function test_fgex(testCase,insrc,selu,nu)
      % Verify this does not throw an error
      [~,~] = fge(testCase.tok,testCase.shot,testCase.t,'insrc',insrc,'selu',selu,'nu',nu);
    end
  
  end
end