classdef argout_test < meq_test
  % tests for custom output arguments
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
 
 properties
  L
  LX
 end

 % Test various sources of data
 properties(ClassSetupParameter)
  shot = {1}
 end
 
 methods (TestClassSetup)
  function setLLX(testCase)
   [Lb,~,LYb] = fbt('ana',1);
   testCase.L = liu('ana',1);
   testCase.LX = meqxconvert(Lb,LYb,testCase.L);
  end
 end
 
 methods (Test, TestTags={'Unit'})
  function basic_argout(testCase)
    % Basic test
    LY = liut(testCase.L,testCase.LX,'argout','kit');
    testCase.verifyNumElements(LY.kit,numel(LY.t));
  end  
    
  function expr_argout(testCase)
    % Expression test
    LY = liut(testCase.L,testCase.LX,'argout','rat1=LYt.Wk./LYt.bp');
    testCase.verifyEqual(LY.rat1,LY.Wk./LY.bp);
  end
    
  function several_argout(testCase)
    % Several outputs test
    LY = liut(testCase.L,testCase.LX,'argout',{'Wk2=LYt.Wk*2','r=rA'});
    testCase.verifyEqual(LY.Wk2,LY.Wk*2);
    testCase.verifyEqual(LY.r,LY.rA,'RelTol',1e-6);
  end
 end
 
end
