classdef anamak_multiD_tests < meq_test
  % Test for multidimensional anamak cases.
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  properties (TestParameter)
    shot   = struct('circular',1,'diverted',2,'droplet',81,...
      'doublet', 82,'diverted_droplet_PFR',   83,...
      'diverted_droplet',   84,...
      'two_diverted_droplets',85);
    sIp    = {-1,1};
  end
  
  properties
    verbosity = 0;
  end
  
  methods(Test,TestTags={'Integration'})
    function test_FR(testCase,sIp,shot)
      % Test of Normalized X-point/Boundary flux ratio value
      [L,LX] = fbt('ana',shot,0,'izgrid',testCase.verbosity>0);
      LX.IpD = sIp*LX.IpD;
      LX.qA  = sIp*LX.qA;
      LY=fbtt(L,LX);
      
      if testCase.verbosity>0
        clf; meqplotfancy(L,LY); drawnow;
      end
      
      switch shot
        case 1
          testCase.verifyEqual(LY.FR,inf,'FR must be inf for circular eq')
        case 2
          testCase.verifyEqual(LY.FR,1,'FR must be 1 for diverted eq');
        case 81
          testCase.verifyGreaterThan(LY.FR(1:2),[1;1],'FR must be > [1 1] for droplets');
          testCase.verifyEqual(LY.FR(3),nan,'Final FR entry must be nan for droplets');
        case 82
          testCase.verifySize(LY.FR,[3 1],'FR must have size [3,1] for doublet');
          testCase.verifyEqual(LY.FR(1:2),[1;1],'First 2 elements of FR must be [1 1] for doublet');
          testCase.verifyLessThan(LY.FR(3),1,'FR(3) must be <1 for doublet')
        case {83,84}
          testCase.verifyTrue(sum(LY.FR==1)==1,'FR must contain one entry =1 for diverted droplet');
          testCase.verifyTrue(sum(LY.FR>1)==1,'FR must contain one entry >1 for diverted droplet');
          testCase.verifyEqual(LY.FR(3),nan,'Final FR entry must be nan for droplets');
        case 85
          testCase.verifyEqual(LY.FR(1:2),[1;1],'First 2 elements of FR must be [1 1] for two diverted droplets');
          testCase.verifyEqual(LY.FR(3),nan,'Final FR entry must be nan for droplets');
        otherwise
          error('unknown shot %d',shot);
      end
    end
  end
  
end
