%% Test of iters (convergence loop of source fitting) in liuqe
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

clear
%%
Tab=table;
ii=1;
[L,LX] = liuqe(61400,0.3);
for itert = [0 30]
  for bfct = {'bf3pmex','bfef'}
    for fdz = [1e-5,1]
      for iters = [0 20 100]
        ii=ii+1; disp(ii);
        
        switch bfct{:}
          case 'bfef', bfp = [2 3]; wreg = 1e-5*[1;1;100];
          case 'bf3pmex', bfp = []; wreg = 0;
        end
        
        L  = liuc(L.P,L.G,...
          'iters',iters,'itert',itert,...
          'bfct',str2func(bfct{:}),'bfp',bfp,...
          'fdz',fdz,'wreg',wreg);
        
        argout = {'A=[L.Wre Wri ; L.Wee zeros(L.ne,L.ng+L.ndz) ; zeros(2+L.nq,L.ne) [Wii ; Wqi]]';...
          'chi=sqrt(mean((Yd-Zd).^2))'};

        LY = liut(L,LX,'argout',argout);
        
        if isempty(LY), continue; end
        
        T.itert = L.P.itert;
        T.iters = L.P.iters;
        T.log10fdz = log10(L.P.fdz);
        T.bfct = bfct;
        T.chi = LY.chi; T.niter = LY.niter;
        T.Wk = LY.Wk;   T.ng = L.ng;
        T.condA = cond(LY.A);
        Tab = [Tab;struct2table(T)];
      end
    end
  end
end

%%
disp(Tab)