% Load RZP parameters, overloading FGEP.
% P = rzpp(P,...)
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function [P] = rzpp(P,varargin)

%% Default Parameters
D.agcon = {'Ip','bp','li'};  % residual function(s) for basis function coeff constraints (see help meqagcon)
D.lin   = true; % run linearized version (the only one present)

%% Overwrites parameters from input and set defaults
for k = 1:2:numel(varargin), P.(varargin{k}) = varargin{k+1}; end
for k = fieldnames(D)'
  if ~isfield(P,k{1}), P.(k{1}) = D.(k{1}); end
end

P = fgep(P);

end
