function G = rzpg(G,P,varargin)
%% G = rzpg(G,P) 
% RZP geometry and electromagnetic parameters 
%
% See also fgeg, fgsg, meqg
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

xargs = [varargin,{'Brxa','Bzxa','Brxu','Bzxu',...
  'drdrMxa','drdrMxu','drdzMxa','drdzMxu','dzdzMxa','dzdzMxu',...
  'drMxa','drMxu','dzMxa','dzMxu'}];

G = fgeg(G,P,xargs{:});

end
