function L = rzpc(P,G)
% Parameter consolidation for rzp
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

%% Generic fgec ancilliary data (includes fgsc and meqc)
L = fgec(P,G);

%% Code specific functions
L.codeinit = @rzpinit; % Initialise the equilibrium based on rzpinit.m
L.codeF = @rzpFlin;    % Call the linearisation for the rzp force balance
L.code = 'rzp';

%% Specific structures for the linearisation
L.drdrMye = [L.G.drdrMxa(L.lxy(:),:) L.G.drdrMxu(L.lxy(:),:)];
L.drdzMye = [L.G.drdzMxa(L.lxy(:),:) L.G.drdzMxu(L.lxy(:),:)];
L.dzdzMye = [L.G.dzdzMxa(L.lxy(:),:) L.G.dzdzMxu(L.lxy(:),:)];
L.Bzye    = [L.G.Bzxa(L.lxy(:),:)    L.G.Bzxu(L.lxy(:),:)   ];

%% Specific rzpFlinfast structures for fast A calculation
L.RBrye = -[L.G.dzMxa(L.lxy(:),:) L.G.dzMxu(L.lxy(:),:)]./(2*pi);
L.RBzye =  [L.G.drMxa(L.lxy(:),:) L.G.drMxu(L.lxy(:),:)]./(2*pi);

end