%MEQVIS  Visualisation function for debugging
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function meqvis(t1,rx,zx,Fx,F,Fb,r,z,srz,b,col,text,t2)
  
 % Cross-section
 if nargin > 10 && ~isempty(b)
  ax = axes('Position',[.1,.1,.35,.8]);
 else
   ax = gca;
 end

 contourf(ax,rx,zx,Fx,F)
 colormap(ax,'jet')

 title(ax,t1)
 hold on
 if ~isnan(Fb)
   % thicker line for LCFS
 FFb = repmat(Fb,1,max(3-numel(Fb),1)); % multi-FB
 contour(ax,rx,zx,Fx,FFb,'linewidth',2,'color','k');
 end
 for k = 1:length(r)
  plot(ax,r{k},z{k},srz{k})
 end
 hold(ax,'off'), axis(ax,'equal','off');
 xlim(ax,rx([1 end])), ylim(ax,zx([1 end]))
 
 % Bars
 if nargin > 10
  axes('Position',[.55,.1,.35,.8])
  nb = length(b);
  hold on
  n = 0;
  for k = 1:nb
   bb = b{k};
   B = sqrt(mean(bb.^2,'omitnan'));
   if B > 1, B = log10(B)+1; end
   l = abs(bb) > 1; bb(l) = sign(bb(l)).*(log10(abs(bb(l)))+1);
   set(barh(n+(1:length(bb)),bb,1,col(k)),'edgecolor','none')
   plot(B*[-1 1;-1 1],[n+0.5;n+length(bb)+.5],['-' col(k)])
   n = n + length(bb);
  end
  hold off
  set(gca,'xlim',[-2 2],'xtick',-2:2,'xticklabel',{'-10' '-1' '0' '1' '10'},'xgrid','on',...
   'ylim',[0 n+1],'ytick',[],'ydir','reverse')
  title(text)
  set(gcf,'Name',t2);
 end
end