function dt = meqdt(t,it)
% dt = meqdt(t,it)
% Compute time difference between two samples of time array t
% Returns dt = t(it+1)-t(it);
% Except if it=numel(t), then it returns t(it)-t(it-1)
% If t has only one sample the function returns 0
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.


if numel(t)==1
  dt = 0; % special case to allow calling fget for only 1 (initial) time step
  return
end
if it == 1
  dt = t(it+1)-t(it);
else
  dt = t(it)-t(it-1);
end
end