function LY = meqLYdot(LY,LYp)
% computation of measurements that depend on time derivative;
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
if LY.t == LYp.t
  LY.Bmdot = zeros(size(LY.Bm));    % ~Voltage measurements of magnetic probes
  LY.Ffdot = zeros(size(LY.Ff));    % =Voltage measurements of flux probes
else
  idt = 1./(LY.t-LYp.t);
  LY.Bmdot = (LY.Bm-LYp.Bm)*idt;
  LY.Ffdot = (LY.Ff-LYp.Ff)*idt;
end
end
