%VIZRMEX  Compute volume integrals
%
% This is the MATLAB equivalent implementation of libmeq/vizr.c.
% A more detailed help is available in VIZRMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function [Wp,Ft0,Vp] = vizrmexm(Fx,Opy,ry,iry,rBt,drx,dzx)
Vp = 2*pi*(sum(Opy)*ry)*drx*dzx;
Ft0 = rBt*(sum(Opy)*iry)*drx*dzx;
[dFdr,dFdz] = gradient(Fx,drx,dzx);
[nz,nr] = size(Fx);
selz = 2:nz-1;
selr = 2:nr-1;

gradPsi2y = dFdr(selz,selr).^2+dFdz(selz,selr).^2;
gradPsioR = (gradPsi2y.*iry'); % |GradPsi|^2/R
Wp = 1/(4*pi*4e-7*pi) * sum(gradPsioR(Opy)) * drx*dzx;