%LOCRMEX  Location of q surfaces
%
% This is the MATLAB equivalent implementation of mexc/locRmex.c.
% A more detailed help is available in LOCRMEX.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function aR = locRmexm(aQ,iqQ,iqR,naR,NF)

if nargin < 5, NF = NaN; end % default
if nargin < 4, naR = 1; end % default
if naR<1, error('invalid naR<1'); end
nR = numel(iqR);
nQ = numel(iqQ);

assert(size(aQ,1)==nQ,...
  'aQ must have numel(iqQ) rows')
aR = repmat(NF,nR,naR); % default value for non-found points

aR(:) = locQ(aQ.',iqQ,iqR,naR,NF); % locQ expects aQ of size [nO,nQ]

end
