/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"
void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* function b = uatamex(a) */

# define MEXNAME uatamex

# define B pout[0]

# define A prhs[0] /* double or single, def size=[m,n] */

 CHECK_NARGIN_EQ(1);

 CHECK_REAL(A);

 CHECK_NARGOUT_LE(1);

 mxArray *pout[1];

 int m = mxGetM(A), n = mxGetN(A);
 switch (mxGetClassID(A)) {
  case mxDOUBLE_CLASS: {
   B = mxCreateDoubleMatrix(n*(n+1)/2, 1, mxREAL);
   duata(mxGetPr(B), mxGetPr(A), m, n);
   break;
  }
  case mxSINGLE_CLASS: {
   B = mxCreateNumericMatrix(n*(n+1)/2, 1, mxSINGLE_CLASS, mxREAL);
   suata((float*)mxGetData(B), (float*)mxGetData(A), m, n);
   break;
  }
 /* Other cases impossible due to CHECK_REAL call */
 }

 ASSIGN_PLHS;
}
