/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* nfd = nfdbmex(f) */

# define MEXNAME nfdbmex

# define NFD pout[0]

# define F   prhs[0] /* double, def size=[nx,ny] */

 CHECK_NARGIN_EQ(1);

 CHECK_DOUBLE(F);

 CHECK_NARGOUT_LE(1);

 mxArray *pout[1];

 int nx = mxGetM(F), ny = mxGetN(F);
 NFD = mxCreateDoubleMatrix(2*(nx-2)+2*(ny-2),1,mxREAL);
 dnfdb(mxGetPr(NFD),mxGetPr(F),nx,ny);

 ASSIGN_PLHS;
}
