/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* [FB,rB,zB,lB,lX] = fbndmex(Fl,rl,zl,FX,rX,zX,FN) */

# define MEXNAME fbndmex

# define FB   pout[0]
# define RB   pout[1]
# define ZB   pout[2]
# define LB   pout[3]
# define LX   pout[4]

# define FL   prhs[0]  /* double, def size=nL */
# define RL   prhs[1]  /* double, size=nL */
# define ZL   prhs[2]  /* double, size=nL */
# define FX   prhs[3]  /* double, def size=nX */
# define RX   prhs[4]  /* double, size=nX */
# define ZX   prhs[5]  /* double, size=nX */
# define FN   prhs[6]  /* numeric, scalar */

 CHECK_NARGIN_EQ(7);

 int nX = mxGetNumberOfElements(FX);
 int nL = mxGetNumberOfElements(FL);

 CHECK_DOUBLE(FL);
 CHECK_DOUBLE(RL);
 CHECK_NUMEL(RL,nL);
 CHECK_DOUBLE(ZL);
 CHECK_NUMEL(ZL,nL);
 CHECK_DOUBLE(FX);
 CHECK_DOUBLE(RX);
 CHECK_NUMEL(RX,nX);
 CHECK_DOUBLE(ZX);
 CHECK_NUMEL(ZX,nX);
 CHECK_NUMERIC(FN);
 CHECK_SCALAR(FN);

 CHECK_NARGOUT_LE(5);

 mxArray *pout[5];
 
 FB = mxCreateDoubleMatrix(1,1,mxREAL);
 RB = mxCreateDoubleMatrix(1,1,mxREAL);
 ZB = mxCreateDoubleMatrix(1,1,mxREAL);
 LB = mxCreateLogicalMatrix(1,1);
 LX = mxCreateLogicalMatrix(1,1);
 
 dfbnd(mxGetPr(FB), mxGetPr(RB), mxGetPr(ZB), (bool *)mxGetLogicals(LB), (bool *)mxGetLogicals(LX),
       mxGetPr(FL), mxGetPr(RL), mxGetPr(ZL),
       mxGetPr(FX), mxGetPr(RX), mxGetPr(ZX), nX, mxGetScalar(FN), nL);

 ASSIGN_PLHS;
}
