/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{

 /* [FI] = bint(FX,K,C) */

# define MEXNAME bintmex

# define FI pout[0]

# define FX prhs[0]  /* double, def size=[nz,*] */
# define K  prhs[1]  /* int32, def size=ni */
# define C  prhs[2]  /* double, size=4*ni */

 int ni, nr, nz, n;
 int mri, nri;
 
 CHECK_NARGIN_EQ(3);
 
 ni = mxGetNumberOfElements(K);
 nz = mxGetM(FX);

 CHECK_DOUBLE(FX);
 CHECK_INT32(K);
 CHECK_DOUBLE(C);
 CHECK_NUMEL(C,4*ni);

 CHECK_NARGOUT_LE(1);

 mxArray *pout[1];
 
 FI = mxCreateDoubleMatrix(ni,1,mxREAL);

 dbint(mxGetPr(FI), mxGetPr(FX), (int*)mxGetData(K), mxGetPr(C), ni, nz);

 ASSIGN_PLHS;
}
