function LX = meqxdoublet(L,LX)
% MEQXDOUBLET - Adds missing fields per domain in case of doublet
% LX = meqxdoublet(L,LX)
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% Fields that have a 'D' counterpart - integral quantities
for ifield = {'IpD','bpD'}
  if ~isfield(LX,ifield{:})
    singletfieldname = ifield{:}(1:end-1);
    if isfield(LX,singletfieldname)
      singletval = LX.(singletfieldname);
    else
      singletval = NaN(1,numel(LX.t));
    end
    
    if any(LX.idoublet)
      % scaling to translate desired global parameters into scalar ones for
      % a symmetric doublet, e.g. bp to bpD
      switch ifield{:}
        case 'IpD',s = 1/2;
        case 'bpD',s = 1/2;
      end
     
      LX.(ifield{:}) = zeros(L.nD,numel(LX.t)); % init
      LX.(ifield{:})(1:2,:) = s*repmat(singletval,2,1);
    else
      % copy from global field (eg Ip) to domain field (eg IpD)
      LX.(ifield{:}) = singletval; 
    end
  end
  
  % qA special, this is always 'per A(xis)' so no D counterpart
  if size(LX.qA,1)==1 && any(L.P.idoublet)
    qA = zeros(2,numel(LX.t)); % init
    qA(1:2,:) = repmat(LX.qA,2,1); % assume same qA for all lobes
    LX.qA = qA;
  end
  
end