function P = meqptcv(shot)
% MEQ-TCV:specific parameters:
% .sela        Active coil selection, cell array, e.g. {'E','F','G','OH'}
% .selx        Computational grid selection, string, e.g. 'X', 'XF'
% .static      Selects the TCV static tree version
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

if nargin < 1 || isempty(shot), shot = -1; end
% defaults for TCV
P.tokamak = 'TCV';
P.tok     = 'tcv';
P.r0 = 0.88; % default radius used for outputs/normalizations
P.b0 = 1.43; % default toroidal field used for outputs/normalizations
P.izgrid = false;
P.mdsserver = 'tcvdata.epfl.ch';
P.selx = 'X'; % default grid
% TCV static tree version
if shot>1e6, tcvshot = floor(shot/1e3); % Handle personal trees
else,        tcvshot = shot;
end
meqmdsopen(-1,'static',[],P.mdsserver)
[P.static,st] = mdsvalue('\version[$1]',mdscvt(tcvshot,'l'));
assert(isodd(st),'Unable to retrieve static tree version for TCV shot %d',tcvshot);
% Values corresponding to the default grid (stored as singles in MDSplus)
meqmdsopen(P.static,'static',[],P.mdsserver);
[rx,str] = mdsvalue('static("r_x:axis")');
[zx,stz] = mdsvalue('static("z_x:axis")');
assert(isodd(str)&&isodd(stz),'Unable to retrieve default grid from the TCV static tree');
P.ri = rx(1);
P.ro = rx(end);
P.zl = zx(1);
P.zu = zx(end);
P.nr =  numel(rx)-1;
P.nz = (numel(zx)-1)/2;
% Default coils
if shot > -1 && shot < 100000, shotm = shot;
else,                          shotm = -1;   end
meqmdsopen(shotm,'magnetics',[],P.mdsserver);
[dima,sta] = mdsvalue('\IPOL:DIM');
assert(isodd(sta),'Unable to retrieve active coil names from TCV magnetics tree for shot %d',shotm);
if ismember('G_001',deblank(dima)), P.sela = {'E','F','G','OH'};
else,                               P.sela = {'E','F',    'OH'}; end
