function [F0,F1] = meqpdomlim(FA,FB,nD)
% returns limiting flux for multi-domain plasmas with FA,FB (works for nB-nA<=1)
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

[F0,F1] = deal(zeros(nD,1));
nA = numel(FA);
nB = numel(FB);

F0(1:nA)    = FA;
F0(nA+1:nB) = FB(1:nB-nA);
F1(1:nB)    = FB;

end