function P = meqpana(shot)
 % Default parameters for Anamak - an analytical test tokamak
 % 
 % Anamak vessel, coils, probes, flux loops are distributed along 
 % concentric elliptical shapes. 
 %
 %
 % .ac       PF coil minor radius
 % .af       Flux loop minor radius
 % .al       Limiter minor radius
 % .am       Magnetic probe minor radius
 % .av       Vessel minor radius
 % .cappav   Vessel elongation
 % .nc       Number of PF coils
 % .nf       Number of flux loops
 % .nl       Number of limiter points
 % .nm       Number of magnetic probes
 % .nv       Number of vessel elements
 % .nW       Number of wall gaps
 % .wc       Coil width
 % .fastcoil Internal fast coil (true/false)
 %
 % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

 P.tokamak = 'anamak';
 P.tok     = 'ana';
 P.shot    = shot;
 P.r0      = 1;
 
 % geometry parameters
 P.nz = 16; % vertical points (must be power of 2, final nz=(2*P.nz+1))
 P.nr = 33; % radial points 
 P.nl = 200; % number of limiter points
 P.nv = 200; % number of vessel elements
 P.nf = 16; % number of flux loop measurements
 P.nm = 16; % number of magnetic probe measurements
 P.nW = 10; % number of wall gaps
 
 P.av = 0.5; % minor radius of vacuum vessel
 P.cappav = 1.1; % elongatoin of the vessel
 P.al = 0.45; % limiter radius
 P.am = 0.47; % magnetic probe radius
 P.af = 0.51; % flux loop radius
 
 P.nc = 8; % number of PF coils
 P.ac = 1.4*P.av; % coil radius
 P.wc = 0.05*P.av; % coil width

 P.fastcoil = false;
 
 % shot dependent overrides
 switch floor(shot/10)
   case 1
     % high elongation
     P.cappav = 2;
     P.nc     = 24;
     P.nz     = 32;
   case 8
     % doublets
     P.cappav = 2;
     P.nc = 16;
     P.nz = 32;
     P.idoublet = 1; % allow doublets
   case 9
     % controller tests
     P.fastcoil = true;
     P.nc       = 9;
 end
 
 end
