/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# ifndef MEQH_H

# define MEQH_H

# include <stdint.h>
# include <math.h>
# include <stdbool.h>
# include <stdlib.h>
# include <stdio.h>
# include <string.h>
# include <sys/time.h>

/* Types */
# ifdef SINGLE
# define FLT float
# else
# define FLT double
# endif
# define FLTC(a) ((FLT)(a))

/* Math */
# if defined CBLAS
 # include <cblas.h>
 # include <vblas.h>
 # include <lapacke.h>
# elif defined MKL
 # include <mkl.h>
# else
 # include <matmkl.h>
 # include <vblas.h>
# endif

/* Mex */
/* Allows a few tweaks if compiled using the mex wrapper: 
 * for ex printf is replaced by mexPrintf */
# if defined MATLAB_MEX_FILE || defined OCTAVE_MEX_FILE
 # include "mex.h"

 /* All checks now defined in genlib */
 # include "genlib/mexargs/include/mexargs.h"

# endif

# endif 
