/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meqh.h"
# ifdef SINGLE
# define FCT  cblas_ssyrk
# define GEMV ssyrk
# else
# define FCT  cblas_dsyrk
# define GEMV dsyrk
# endif
void FCT(const CBLAS_LAYOUT Layout, const CBLAS_UPLO uplo, const CBLAS_TRANSPOSE trans, 
         const int n, const int k, const FLT alpha, const FLT *a, const int lda,
         const FLT beta, FLT *c, const int ldc)
{
 ptrdiff_t n_, k_, lda_, ldc_;
 char * up = uplo == CblasUpper ? "U" : "L";
 char * tr = trans == CblasNoTrans ? "N" : (trans == CblasTrans ? "T" : "C");
 n_ = n; k_ = k; lda_ = lda; ldc_ = ldc;
 GEMV(up, tr, &n_, &k_, &alpha, a, &lda_, &beta, c, &ldc_);
}
