function X = liuxana(shot,t,L)
% LIUXANA - Input data for ANAMAK
% run FBT to get liuqe input data for anamak
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
PP = [fieldnames(L.P),struct2cell(L.P)]';
[Lb,~,LYb] = fbt('ana',shot,[],PP{:},'iterq',0); % input time is arbitrary for fbtana (one equilibrium)
assert(~isempty(LYb),'fbt did not converge for anamak shot %d',shot)
if isempty(t), t=LYb.t; end

% keep only measurements
fields = {'t','Bm','Ff','Ip','Ia','Iu','Ft','rBt'};
for ii=fields
  LY.(ii{:}) = LYb.(ii{:});
end
X = meqxconvert(Lb,LY,L);
X = meqlpack(repmat(X,numel(t),1));
X.shot = shot;
X.t = t;
 
end