function G = liugtcv(shot,P)
%LIUGTCV  TCV LIUQE geometry and electromagnetic parameters
% LIUGTCV(SHOT,P) returns a structure with geometry and electromagnetic
% parameters for TCV SHOT. See also MEQGTCV,LIUG.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% Flux loop selection
self = 'F';

P.shot = shot;
selc = P.izgrid;
xargs = {'Bms','Rs','Brxa','Brxu'};
G = meqgtcv(P,P.sela,38,128,1:38,1:38,P.selx,P.selu,selc,xargs{:});

%% dz-stabilization scheme
if ~isempty(P.selx)
 meqmdsopen(P.static,'STATIC',[],P.mdsserver);
 if strcmp(self,'F1')
  G.dzMfx =            -mdsdata('STATIC("DMUTDZI_"//$1//"_"//$2)[$3,*]',self,P.selx,G.dimf);
 else
  G.dzMfx = -2*pi*G.rf.*mdsdata('STATIC(     "BR_"//$1//"_"//$2)[$3,*]',self,P.selx,G.dimf);
 end
  
 G.dzBmx  =  cos(G.am).*mdsdata('STATIC(         "DBRDZ_M_"//$1)[$2,*]',     P.selx,G.dimm) + ...
             sin(G.am).*mdsdata('STATIC(         "DBZDZ_M_"//$1)[$2,*]',     P.selx,G.dimm);
end

%% DML
if P.idml
 meqmdsopen(shot,'TCV_SHOT',[],P.mdsserver);
 % DML plasma current coupling
 k = find(strcmp('FIX-PLA-LIN',deblank(mdsdata('GETNCI("\\RESULTS::DML:BO0%%.PARAM:TYPE","RECORD")'))));
 if ~isempty(k) && strcmp(P.selx,'X')
  mdsstr = sprintf('\\RESULTS::DML:BO%03d:C',k);
  [dd,status] = mdsdata(mdsstr);
  assert(isodd(status),'Error loading %s for shot %d',mdsstr,shot);
  G.Mtx = reshape(dd,numel(G.rx),numel(G.zx))'/((G.rx(2)-G.rx(1))*(G.zx(2)-G.zx(1)));
 end
end

%% Plasma current estimator: Ip = Ipm*Bm + Ipa*Ia + Ipu*Iu
G.Ipm = sqrt(diff([G.rm(end) G.rm']).^2 + diff([G.zm(end) G.zm']).^2);
G.Ipm = (G.Ipm+G.Ipm([2:end 1]))/(2*mu0);
 
