%LIUDZ  LIUQE vertical stabilisation function based on shift fitting
% DZ = ZF(P,RST,~,~,DZG) returns the stabilising vertical shift fedback on DZG
% with PI gains P.stab and P.stabint.
%
% For details, see: [MEQ-redbook] 
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function dz = liudz(P,rst,~,~,dzg)
 persistent zdzg
 if nargin
  if rst
   zdzg = 0;
  end
  dz = P.stab*dzg + P.stabint*zdzg;
  zdzg = zdzg + dzg;
 else
  dz = true;
 end
end
