/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "vblas.h"
/* These functions are defined in MKL, not in CBLAS */


/* Element-wise inversion */
void vdInv(const int n, const double *a, double *y){
    for(int i=n; i--;) *y++ = 1./(*a++);
}

void vsInv(int n, const float *a, float *y){
    for(int i=n; i--;) *y++ = 1./(*a++);
};

/* Addition */
void vsAdd(const int n, const float *a, const float *b, float *y){
    for(int i=n; i--;) *y++ = (*a++)+(*b++);
};

void vdAdd(const int n, const double *a, const double *b, double *y){
    for(int i=n; i--;) *y++ = (*a++)+(*b++);
};

/* Subtraction */
void vsSub(const int n, const float *a, const float *b, float *y){
    for(int i=n; i--;) *y++ = (*a++)-(*b++);
};

void vdSub(const int n, const double *a, const double *b, double *y){
    for(int i=n; i--;) *y++ = (*a++)-(*b++);
};

/* Multiplication */
void vsMul(const int n, const float *a, const float *b, float *y){
    for(int i=n; i--;) *y++ = (*a++)*(*b++);
};

void vdMul(const int n, const double *a, const double  *b, double *y){
    for(int i=n; i--;) *y++ = (*a++)*(*b++);
};

/* Division */
void vsDiv(const int n, const float *a, const float  *b, float *y){
    for(int i=n; i--;) *y++ = (*a++)/(*b++);
};

void vdDiv(const int n, const double *a, const double  *b, double *y){
    for(int i=n; i--;) *y++ = (*a++)/(*b++);
};
