/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"
# ifdef SINGLE
# define FCT sbfpr
# else
# define FCT dbfpr
# endif

void FCT(FLT *IgNg, FLT *gNg, int n) {
 int i, n1=n-1;
 if (n == 0) return;
 FLT d=FLTC(-0.5)/n1, x;
 IgNg += n1; gNg += n1;
 FLT *Ig1=IgNg+n, *Ig2=Ig1+n,
      *g1= gNg+n,  *g2= g1+n;
 *IgNg = *Ig1 = *Ig2 = FLTC(0.0);
 for (i=n1; i--; gNg--, g1--, g2--) {
  x = *IgNg + (*gNg + *(gNg-1)) * d;
  *(--IgNg) = x;
  x = *Ig1 + (*g1 + *(g1-1)) * d;
  *(--Ig1) = x;
  x = *Ig2 + (*g2 + *(g2-1)) * d;
  *(--Ig2) = x;
 }
}
