/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"

# ifdef SINGLE
# define FCT sasgn
# define BCP cblas_scopy
# else
# define BCP cblas_dcopy
# define FCT dasgn
# endif
# define CPY(y,x,n) BCP(n,x,1,y,1) /* y = x */

void FCT(FLT *y, FLT *y0, FLT *u, int *iu, int ny, int nu) {
 int ku;
 /* y = y0 */
 CPY(y,y0,ny);
 /* y(iu) = u */
 for (ku=0; ku<nu; ku++) {
  y[iu[ku]] = u[ku];
 }
}
