classdef genlib_submodule_fixture < matlab.unittest.fixtures.Fixture
  % GENLIB_SUBMODULE_FIXTURE Test fixture to check submodules have been correctly initialized	
  %
  % [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  methods
    function setup(testCase)
      genlib_path = fileparts(fileparts(mfilename('fullpath')));
      mexargs_file = fullfile(genlib_path,'mexargs','mexargs.m');
      test = exist(mexargs_file,'file')>0;
      testCase.assertTrue(test,...
        sprintf('The file %s was not found, check that the "mexargs" submodule has been initialized properly.\n See the README.md file for instructions.',mexargs_file));
    end
  end
end
