/* [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
/*
ifloor

returns the indices of the elements in a look-up table which are nearest but
smaller than the given values.

void ifloor(k,T,sizeT,X,sizeX)

int 	*k;	indices of the nearest but smaller elements
		in table T for each value of X, -1 for X < T[0]
double	*T;	table to look up, must be sorted
int	sizeT;
double	*X;	values to look up, must be sorted 
int	sizeX;
*/

void ifloor(k,T,sizeT,X,sizeX)

int 	*k;
double	*T;
int	sizeT;
double	*X;
int	sizeX;

{
	register int	i = 0, j = 0;

	/* treat values smaller that T[0] */
	while (i < sizeX && X[i] < T[0]) k[i++] = -1;

	/* do the work */
	for (; i < sizeX; i++) {
		k[i] = sizeT - 1; /* treat values larger than T[sizeT-1] */
		for (; j < sizeT-1; j++)
			if (X[i] >= T[j] && X[i] < T[j+1]) {
				k[i] = j;
				break;
			}
	}
}
/* CMS REPLACEMENT HISTORY, Element IFLOOR.C*/
/* *2     6-MAR-1995 17:20:57 MORET "do not remember why"*/
/* *1    26-JUL-1993 15:13:45 MORET ""*/
/* CMS REPLACEMENT HISTORY, Element IFLOOR.C*/
