function [ym,xm] = minloc(y,x,d)

% MINLOC   Minimum location
%    [YM,XM] = MINLOC(Y,X,N) returns for two arrays X and Y of same size the
%    values XM of X where Y is minimum along the its Nth dimension. YM is
%    min(Y,[],D).
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

[ym,k] = min(y,[],d);
nx = size(x);
xm = reshape(permute(x,[d 1:d-1 d+1:length(nx)]),[nx(d),prod(nx)/nx(d)]);
xm = reshape(xm(sub2ind(size(xm),k(:)',1:size(xm,2))),size(ym));
