/* [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "genlib.h"

void mexFunction(int nlhs,       mxArray *plhs[],
                 int nrhs, const mxArray *prhs[])
{

# define MEXNAME bspbasemex

 /* b = bspbasemex(t,k,x); */

# define B  pout[0]

# define T  prhs[0] /* double */
# define K  prhs[1] /* numeric, scalar */
# define X  prhs[2] /* double */

 CHECK_NARGIN_EQ(3);
 
 CHECK_DOUBLE(T);
 CHECK_NUMERIC(K);
 CHECK_SCALAR(K);
 CHECK_DOUBLE(X);

 CHECK_NARGOUT_LE(1);

 mxArray *pout[1];

 int		k, sizeX, sizeT, nbase;
 int		*d;
 register int	i;

 k = mxGetScalar(K);
 sizeX = mxGetM(X) * mxGetN(X);
 sizeT = mxGetM(T) * mxGetN(T);
 nbase = sizeT - k;

 B = mxCreateDoubleMatrix(nbase, sizeX, mxREAL);
 bspbase(mxGetPr(B), mxGetPr(T), sizeT, k, mxGetPr(X), sizeX);

 ASSIGN_PLHS;
}
