/* [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# ifndef GENLIB_H

# define GENLIB_H

# if defined OCTAVE_MEX_FILE

 # include "stdbool.h"

# endif

# if defined MATLAB_MEX_FILE || defined OCTAVE_MEX_FILE

 # include "mex.h"
 # include "../mexargs/include/mexargs.h"

# endif

void bspbase(double *B, double *T, int sizeT, int k, double *X, int sizeX);
void bspsum(double *V, double *T, int nT, double *C, int nC, double *X, int nX, int d);
# ifdef BSPSUM4
void bspsum40(double *V, double *T, int nT, double *C, int nC, double *X, int nX, int d);
void bspsum41(double *V, double *T, int nT, double *C, int nC, double *X, int nX, int d);
void bspsum42(double *V, double *T, int nT, double *C, int nC, double *X, int nX, int d);
# endif
double ellipfast(double y, int kind);
void greenem(int *mode, int nm, bool der1, bool der2, double r1, double z1, double r2, double z2, double **y);


# endif
