# GENLIB - general purpose library for SPC/TCV 
#
# [+GenLib General Purpose Library+] Swiss Plasma Center EPF Lausanne 2022. All rights reserved.


Code suite maintainers: 

* [Antoine Merle](mailto:antoine.merle@epfl.ch)
* [Federico Felici](mailto:federico.felici@epfl.ch)

## Installation:

To install for the first time, first ask the maintainers for access to the `genlib` toolbox.
### Get the code
```
# Clone, e.g.
git clone git@gitlab.epfl.ch:spc/tcv/tbx/genlib.git
# initialize and update submodules
git submodule update --init --recursive
```

### Build

`genlib` is built using the `make` command. The default target builds all MEX-file binaries. It is highly recommended to provide the path to the MATLAB installation using the `MATPATH` variable. The C compiler can also be chosen using the CC variable.

For example the following line builds `genlib` with GCC
```
# make genlib
make CC=gcc MATPATH=<path_to_matlab>
```
#### General makefile options:

`genlib` makefile targets:

* `all`
* `clean`

`genlib` makefile options:

* `CC`: Compiler (`gcc` or `icc`, default is the compiler as defined by `mex -setup C` - on Linux this is `gcc`)
* `MATPATH`: Path of `MATLAB` installation (e.g. `$MATPATH/bin/mex` must exist) 
* `USE_OPENMP`: If set to "no" then OpenMP directives will be ignored (affects bspsummex only).
  On MacOS and unless using `icc`, `USE_OPENMP=no` has to be used or a Makefile error will be triggered.

#### On SPC LAC clusters 
On a machine with `icc`:
```
make all CC=icc
```

#### On a Windows machine

On a Windows system with `MSYS2-MINGW64` installed, run the following command from an `MSYS2-MINGW64` shell:
```
make CC=gcc MATPATH="/c/Program\ Files/MATLAB/R2022b" all
```

### Testing
Run the tests:
```matlab
run_genlib_tests('all')
```
