function P = fgsptcv(shot,varargin)
% defines FGS parameters for TCV
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
P = meqptcv(shot);

for k = 1:2:length(varargin), P.(varargin{k}) = varargin{k+1}; end

%% defaults
D.insrc = 'fbt';
D.selu = 'v'; % vessel filament description by default
D.izgrid = true;

for k = fieldnames(D)'
  if ~isfield(P,k{1}), P.(k{1}) = D.(k{1}); end
end

P.shot = shot;

end
