function [Prec,J] = fgepre(L,dt)
% Computes preconditioner for FGE using lin terms
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

iy = L.ind.iy; ig = L.ind.ig; ip = L.ind.ip;
ia = L.ind.ia; iu = L.ind.iu; ie = [ia,iu];
iF = [iy,ig,ip]; % indices into F (rows of J)

% Part of J based on FGS linearization
J = zeros(L.nN); % order in state variables and residuals match by construction
J(iF,iF) = [L.lin.dFdIy,L.lin.dFdag,L.lin.dFdIp]; 
J(iF,ie) =  L.lin.dFdIe;
% Part of J based on circuit equations
rese = L.resscal(ie);
J(ie,ie) = rese.* ( L.Mee/dt+diag(L.Re) );
J(ie,iy) = rese.* ( L.Mey/dt );

Prec = inv(J);

end