%FBTPANA  ANA FBT configuration parameters
% P = FBTPANA(SHOT,'PAR',VAL,...) returns a structure P with configuration
% parameters for ANA tokamak, optionally replacing or adding
% parameters with specified values. See also FBTP.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function P = fbtpana(shot,varargin)
 
 % defaults for ana
 P = meqpana(shot);

 % customize
 P.bfct = @bfabmex;
 P.bfp  = [1 2];
 P.agfitfct = @meqfit3;
 
 P.dissi   = 1e-17;
 P.dipol   = 0;
 P.tol     = 1e-6;
 
 % adds/overwrites parameters
 for k = 1:2:nargin-1
  P.(varargin{k}) = varargin{k+1};
 end
 
 % Constraints
 Imax = Inf; % no constraint
 na = P.nc;
 P.limc = eye(na);
 P.limu = repmat(+Imax,na,1);
 P.liml = repmat(-Imax,na,1);
 
 % checks
 legacy_fields = {'Ip','qA','li','bp','bpD','IpD','bt'};
 ioffending = isfield(P,legacy_fields);
 assert(~any(ioffending),...
   'Passing fields P.%s is deprecated, must pass directly through LX\n',legacy_fields{ioffending})
 
end
