%FBTP  FBTE default configuration parameters
% P = FBTP(P,'PAR',VAL,...) fills the structure P with default
% configuration parameters, optionally replacing or adding parameters with
% specified values.
%
% FBT-specific parameters:
% .agfitfct    Fitting function handle for basis function coefficients
% .agfitp      Parameters for fitting function
% .limm        Margin factor for coil current limits, values lower than 1 are more conservative. Can be a scalar or a column vector with as many elements as limits.
% .dissi       High dissi promotes low coil currents   (in gpid)
% .dipol       High dipol promotes low dipole currents (in gpdd)
% .mergex      If true, merge redundant X-point constraints in LX
%
% Quantities which will end up in LX
% .tol         Default tol
% .issym       If true, force up-down summetric current distribution
% .capaj       High capaj means stronger peaking of initial plasma current density guess
% .niter       Maximum number of iterations
%
% if bffbt basis function is used, additional parameters exist which are documented in BFPFBT
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

function P = fbtp(P,varargin)
 
 %% Default parameters
 D = meqp(); 
 D.agfitfct = @meqfit3;
 D.agfitp   = []; % parameters for fbt fit fuction
 D.dissi    = 1e-17; 
 D.dipol    = 0;  
 D.mergex   = true;
 D.selu     = 'n'; % no vessel currents in fbt 
 D.limm     = 1;   % Use default coil current limits

 % quantities which will end up in LX
 D.tol      = 1e-6; % default tol
 D.issym    = false;
 D.capaj    = 0.5;
 D.niter    = 100;
 
 %% Overwrites and set defaults
 for k = 1:2:length(varargin), P.(varargin{k}) = varargin{k+1}; end
 for k = fieldnames(D)'
  if ~isfield(P,k{1}), P.(k{1}) = D.(k{1}); end
 end
  
 %% Base function parameters
 if isequal(func2str(P.bfct),'bffbt')
   P.bfp = bfpfbt(P);
 end

 %% Check configuration parameters
 msgid = 'FBT:ParameterNotSupported';
 msge = 'FBT Parameter error: %s %g';
 assert(isscalar(P.limm) || (iscolumn(P.limm) && numel(P.limm) == numel(P.limu)),msgid,msge,...
   'limm should be a scalar or a column vector with as many elements as limu');
end
