%BSLVMEX  Block solving algorithm
% [a,b] = BSLVMEX(a1,b1,b0,A,B,NI) solves the system
% [a;b]=[a1;b1]-[A,B]*[a;b] by setting b=b0 and running NI iterations
% a=a1-A*b, b=b1-B*a.
%
% For details, see: [J-M.Moret et al. Fus.Eng.Des 2015], Section 4.4 
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function [a,b] = bslvmex(a1,b1,b0,A,B,ni)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 b = b0;
 for k = 1:ni
  a = a1 - A*b;
  b = b1 - B*a;
 end
end