| Type       | Name          | Units | Description                                                                                                                                                                                                        | Default value        | Node name (OLD) | Node name (NEW) | Default node value | Proposed name | Proposed units | Proposed description                                                                                                                                                                                               | Proposed node name | Proposed node default value | Comments                          |
|------------|---------------|-------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------|-----------------|-----------------|--------------------|---------------|----------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------|-----------------------------|-----------------------------------|
| MEQP       | .tokamak      |       | 'name'                                                                                                                                                                                                             | ''                   |                 |                 |                    | .tokamak      |                | 'name'                                                                                                                                                                                                             |                    |                             | Auto. filled                      |
|            | .shot         |       | #shotnum                                                                                                                                                                                                           | []                   |                 |                 |                    | .shot         |                | #shotnum                                                                                                                                                                                                           |                    |                             | Auto. filled                      |
|            | .debug        |       | debug flag                                                                                                                                                                                                         | 0                    |                 |                 |                    | .debug        |                | debug flag                                                                                                                                                                                                         |                    |                             | Expert user only                  |
|            | .dasm         |       | Minimal distance (grid points) between X and axis points [asxy]                                                                                                                                                    | 2                    |                 |                 |                    | .dasm         |                | Minimal distance (grid points) between X and axis points [asxy]                                                                                                                                                    | **DASM**           | **2**                       |                                   |
|            | .lasy         |       | Search axes and X-points also outside the limiter contour                                                                                                                                                          | FALSE                |                 |                 |                    | .lasy         |                | Search axes and X-points also outside the limiter contour                                                                                                                                                          | **LASY**           | **FALSE**                   |                                   |
|            | .xdoma        |       | Angle of X-point polygon edges with perpendicular (>0 values to get a smaller polygon) [pdom]                                                                                                                      | 0                    |                 |                 |                    | .xdoma        |                | Angle of X-point polygon edges with perpendicular (>0 values to get a smaller polygon) [pdom]                                                                                                                      | **XDOMA**          | **0**                       |                                   |
|            | .isaddl       |       | If isaddl=0, ignore X-points when searching LCFS                                                                                                                                                                   | 1                    | ISADDL          | ISADDL          | 1                  | .isaddl       |                | If isaddl=0, ignore X-points when searching LCFS                                                                                                                                                                   | ISADDL             | 1                           |                                   |
|            | .r0           |       | default major radius used for outputs/normalizations                                                                                                                                                               | 1                    |                 |                 |                    | .r0           |                | default major radius used for outputs/normalizations                                                                                                                                                               | **R0**             | **0.88**                    |                                   |
|            | .b0           |       | default toroidal field used for outputs/normalizations                                                                                                                                                             | 1                    |                 |                 |                    | .b0           |                | default toroidal field used for outputs/normalizations                                                                                                                                                             | **B0**             | **1.44**                    |                                   |
|            | .pq           |       | If specified provides user-defined radial grid (excl LCFS and axis)                                                                                                                                                |                      |                 |                 |                    | .pq           |                | If specified provides user-defined radial grid (excl LCFS and axis)                                                                                                                                                | **PQ**             | **[1:40]/40**               |                                   |
|            | .pqu          |       | maximum rho-psi for contours                                                                                                                                                                                       | sqrt(0.95)           |                 |                 |                    | .pqu          |                | maximum rho-psi for contours                                                                                                                                                                                       | **PQU**            | **sqrt(0.95)**              |                                   |
|            | .pql          |       | minimum rho-psi for contours                                                                                                                                                                                       | 0.2                  |                 |                 |                    | .pql          |                | minimum rho-psi for contours                                                                                                                                                                                       | **PQL**            | **0.2**                     |                                   |
|            | .npq          |       | number of contour integrals to compute (excl LCFS and axis)                                                                                                                                                        | 18                   |                 |                 |                    | .npq          |                | number of contour integrals to compute (excl LCFS and axis)                                                                                                                                                        | **NPQ**            | **39**                      |                                   |
|            | .noq          |       | size of theta-grid mesh for contours                                                                                                                                                                               | 32                   |                 |                 |                    | .noq          |                | size of theta-grid mesh for contours                                                                                                                                                                               | **NOQ**            | **32**                       |                                   |
|            | .ri           | [m]   | Inner boundary of computational grid                                                                                                                                                                               | NaN                  | RI              | RI              | 0.614              | .ri           | [m]            | Inner boundary of computational grid                                                                                                                                                                               | RI                 | **NaN**                     |                                   |
|            | .ro           | [m]   | Outer boundary of computational grid                                                                                                                                                                               | NaN                  | RO              | RO              | 1.147              | .ro           | [m]            | Outer boundary of computational grid                                                                                                                                                                               | RO                 | **NaN**                     |                                   |
|            | .rip          | [m]   | Inner boundary for FE                                                                                                                                                                                              | NaN                  | RIP             | RIP             | Shot-dep.          | .rip          | [m]            | Inner boundary for FE                                                                                                                                                                                              | RIP                | **NaN**                     | Should be in liup                 |
|            | .rop          | [m]   | Outer boundary for FE                                                                                                                                                                                              | NaN                  | ROP             | ROP             | Shot-dep.          | .rop          | [m]            | Outer boundary for FE                                                                                                                                                                                              | ROP                | **NaN**                     | Should be in liup                 |
|            | .zl,zu        | [m]   | Lower/upper boundary of computational grid                                                                                                                                                                         | NaN                  | ZU              | ZU              | 0.76               | .zu           | [m]            | Upper boundary of computational grid                                                                                                                                                                               | ZU                 | **NaN**                     |                                   |
|            | .zl,zu        | [m]   | Lower/upper boundary of computational grid                                                                                                                                                                         | NaN                  |                 |                 |                    | .zl           | [m]            | Lower boundary of computational grid                                                                                                                                                                               | **ZL**             | **NaN**                     |                                   |
|            | .zlp          | [m]   | Lower boundary for FE                                                                                                                                                                                              | NaN                  | ZLP             | ZLP             | Shot-dep.          | .zlp          | [m]            | Lower boundary for FE                                                                                                                                                                                              | ZLP                | **NaN**                     | Should be in liup                 |
|            | .zup          | [m]   | Upper boundary for FE                                                                                                                                                                                              | NaN                  | ZUP             | ZUP             | Shot-dep.          | .zup          | [m]            | Upper boundary for FE                                                                                                                                                                                              | ZUP                | **NaN**                     | Should be in liup                 |
|            | .selu         |       | Generalized vessel description selector string e.g. 's','e','v';                                                                                                                                                   | ''                   |                 |                 |                    | .selu         |                | Generalized vessel description selector string e.g. 's','e','v';                                                                                                                                                   | **SELU**           | **'sx'**                    |                                   |
|            | .nu           |       | Number of vessel variables (eigenmodes, segments)                                                                                                                                                                  | []                   |                 |                 |                    | .nu           |                | Number of vessel variables (eigenmodes, segments)                                                                                                                                                                  | **NU**             | **[]**                      |                                   |
|            | .nFW          |       | Number of fluxes to track for wall gaps. >1 gives secondary separatrices                                                                                                                                           | 1                    |                 |                 |                    | .nFW          |                | Number of fluxes to track for wall gaps. >1 gives secondary separatrices                                                                                                                                           | **NFW**            | **1**                       |                                   |
|            | .rn           | [m]   | Radial points for flux, field interpolations                                                                                                                                                                       | []                   |                 |                 |                    | .rn           | [m]            | Radial points for flux, field interpolations                                                                                                                                                                       | **RN**             | **[]**                      |                                   |
|            | .zn           | [m]   | Z points for flux, field interpolations                                                                                                                                                                            | []                   |                 |                 |                    | .zn           | [m]            | Z points for flux, field interpolations                                                                                                                                                                            | **ZN**             | **[]**                      |                                   |
|            | .bfct         |       | Basis function handle                                                                                                                                                                                              | @bfabmex             |                 |                 |                    | .bfct         |                | Basis function handle                                                                                                                                                                                              | **BFCT**           | **'@bf3pmex'**              |                                   |
|            | .bfp          |       | Basis function parameters                                                                                                                                                                                          | []                   |                 |                 |                    | .bfp          |                | Basis function parameters                                                                                                                                                                                          | **BFP**            | **[]**                      |                                   |
|            | .infct        |       | Interpolation function handle                                                                                                                                                                                      | []                   |                 |                 |                    | .infct        |                | Interpolation function handle                                                                                                                                                                                      | **INFCT**          | **[]**                      |                                   |
|            | .inp          |       | Interpolation function parameters                                                                                                                                                                                  | []                   |                 |                 |                    | .inp          |                | Interpolation function parameters                                                                                                                                                                                  | **INP**            | **[]**                      |                                   |
|            | .interpmethod |       | Interpolation method for data (default: nearest)                                                                                                                                                                   | 'nearest'            |                 |                 |                    | .interpmethod |                | Interpolation method for data (default: nearest)                                                                                                                                                                   |                    |                             | Not in use at all                 |
|            | .fancyplot    |       | Get geometry data for fancy plotting                                                                                                                                                                               | FALSE                |                 |                 |                    | .fancyplot    |                | Get geometry data for fancy plotting                                                                                                                                                                               |                    |                             | Viz only                          |
|            | .iterq        |       | Iterations of contour algorithm, enables contour-dependent calculations                                                                                                                                            | 0                    |                 |                 |                    | .iterq        |                | Iterations of contour algorithm, enables contour-dependent calculations                                                                                                                                            | **ITERQ**          | **0**                       |                                   |
|            | .idoublet     |       | If idoublet, expect doublet                                                                                                                                                                                        | 0                    |                 |                 |                    | .idoublet     |                | If idoublet, expect doublet                                                                                                                                                                                        | **IDOUBLET**       | **0**                       |                                   |
|            | .ndom        |       | Maximum number of allowed domains                                                                                                                                                                                   | 0                    |                 |                 |                    | .idoublet     |                | Maximum number of allowed domains                                                                                                                                                                                  | **NDOM**           | **1**                       |                                   |
|            |               |       |                                                                                                                                                                                                                    |                      |                 |                 |                    |               |                |                                                                                                                                                                                                                    |                    |                             |                                   |
| LIUP       | .argout       |       | Optional list of fields for LY (output) to be specified as a cell array of strings with list of VAR=EXPR or VAR, e.g. P.argout={'PpQg','zIp=zA*Ip'}                                                                |                      |                 |                 |                    | .argout       |                | Optional list of fields for LY (output) to be specified as a cell array of strings with list of VAR=EXPR or VAR, e.g. P.argout={'PpQg','zIp=zA*Ip'}                                                                |                    |                             | Expert user only                  |
|            | .berr         | [T]   | Error in B field measurements                                                                                                                                                                                      | +Inf                 | BERR            | BERR            | 0.01               | **.Bmerr**    | [T]            | Error in B field measurements                                                                                                                                                                                      | **BMERR**          | 0.01                        |                                   |
|            | .cerr         | [A]   | Error in current measurements                                                                                                                                                                                      | +Inf                 | CERR            | CERR            | 200                | **.Iuerr**    | [A]            | **Error in vessel current measurements**                                                                                                                                                                           | **IUERR**          | **200**                     |                                   |
|            |               |       |                                                                                                                                                                                                                    |                      |                 |                 |                    | **.Iaerr**    | **[A]**        | **Error in active coil current measurements**                                                                                                                                                                      | **IAERR**          | **200**                     |                                   |
|            | .chimax       |       | Maximum cost function for accepting equilibrium                                                                                                                                                                    | 2                    | CHIMAX          | CHIMAX          | 3                  | .chimax       |                | Maximum cost function for accepting equilibrium                                                                                                                                                                    | CHIMAX             | 3                           |                                   |
|            | .elomin       |       | If kappa < elomin, p'=0, only 1st base function for TT'                                                                                                                                                            | 1.2                  | ELOMIN          | ELOMIN          | 1.1                | .elomin       |                | If kappa>elomin, regularization weight decreases with elongation, else it is equal to wreg.                                                                                                                        | ELOMIN             | 1.1                         |                                   |
|            | .fdz          |       | Scaling factor for dz fitting parameter                                                                                                                                                                            | 1                    |                 |                 |                    | .fdz          |                | Scaling factor for dz fitting parameter                                                                                                                                                                            | **FDZ**            | **1.00E-05**                |                                   |
|            | .ferr         | [Wb]  | Error in flux measurement                                                                                                                                                                                          | +Inf                 | FERR            | FERR            | 0.0075             | **.Fferr**    | [Wb]           | Error in flux measurement                                                                                                                                                                                          | **FFERR**          | 0.0075                      |                                   |
|            | .fetype       |       | Finite Element type for liu initial guess                                                                                                                                                                          | 'bil'                |                 |                 |                    | .fetype       |                | Finite Element type for liu initial guess                                                                                                                                                                          | **FETYPE**         | **'bil'**                   |                                   |
|            | .idml         |       | If idml~0, use diamagnetic flux measurement                                                                                                                                                                        | 1                    | IDML            | IDML            | 1                  | .idml         |                | If ~0, use diamagnetic flux measurement                                                                                                                                                                            | IDML               | 1                           |                                   |
|            | .ipm          |       | If ipm=1, use Interior-point Method for least-squares fit of currents                                                                                                                                              | 0                    |                 |                 |                    | .ipm          |                | If ipm=1, use Interior-point Method for least-squares fit of currents                                                                                                                                              | **IPM**            | **0**                       |                                   |
|            | .ipmi         |       | Maximum number of iterations in inner loop of Interior-point method for current fit. This should be used only if ipm=1.                                                                                            | 0                    |                 |                 |                    | .ipmi         |                | Maximum number of iterations in inner loop of Interior-point method for current fit. This should be used only if ipm=1.                                                                                            | **IPMI**           | **0**                       |                                   |
|            | .ipmo         |       | Maximum number of iterations in outer loop of Interior-point method for current fit. This should be used only if ipm=1.                                                                                            | 0                    |                 |                 |                    | .ipmo         |                | Maximum number of iterations in outer loop of Interior-point method for current fit. This should be used only if ipm=1.                                                                                            | **IPMO**           | **0**                       |                                   |
|            | .iqR          |       | List of 1/q-values for surface tracking                                                                                                                                                                            | []                   |                 |                 |                    | .iqR          |                | List of 1/q-values for surface tracking                                                                                                                                                                            | **IQR**            | **[]**                      |                                   |
|            | .itera        |       | Maximum number of iterations                                                                                                                                                                                       | 100                  | ITERA           | ITERA           | 100                | .itera        |                | Maximum number of iterations                                                                                                                                                                                       | ITERA              | 100                         |                                   |
|            |               |       |                                                                                                                                                                                                                    |                      |                 |                 |                    | .iterfrz      |                | Number of Picard iterations before which plasma domain is frozen to ease convergence (inactive if itert>0)                                                                                                         | **ITERFRZ**        | **50**                      |                                   |
|            | .iterh        |       | Maximum number of FE solver iterations                                                                                                                                                                             | 0                    |                 |                 |                    | .iterh        |                | Maximum number of FE solver iterations                                                                                                                                                                             | **ITERH**          | **30**                      |                                   |
|            | .iters        |       | Number of block-solver iterations. 0 uses non-iterative solver                                                                                                                                                     | 12                   |                 |                 |                    | .iters        |                | Number of block-solver iterations. 0 uses non-iterative solver                                                                                                                                                     | **ITERS**          | **12**                      |                                   |
|            | .itert        |       | Maximum number of real-time iterations (0=off-line with itera)                                                                                                                                                     | 0                    |                 |                 |                    | .itert        |                | Maximum number of real-time iterations (0=off-line with itera)                                                                                                                                                     | **ITERT**          | **0**                       |                                   |
|            | .ivesm        |       | If ivesm~0, use vessel measurements                                                                                                                                                                                | 1                    |                 |                 |                    | .ivesm        |                | If ivesm~0, use vessel measurements                                                                                                                                                                                | **IVESM**          | **1**                       |                                   |
|            | .naas         |       | Number of base functions for p'. This should be used only if bfct=bfabmex.                                                                                                                                         | 1                    | NAAS            | NAAS            | 1                  | .naas         |                | Number of base functions for p'. This should be used only if bfct=bfabmex.                                                                                                                                         | NAAS               | 1                           |                                   |
|            | .nbbs         |       | Number of base functions for TT'. This should be used only if bfct=bfabmex.                                                                                                                                        | 2                    | NBBS            | NBBS            | 2                  | .nbbs         |                | Number of base functions for TT'. This should be used only if bfct=bfabmex.                                                                                                                                        | NBBS               | 2                           |                                   |
|            | .nelem        |       | Number of FE for initial guess of the current distribution                                                                                                                                                         | 6                    | NELEM           | NELEM           | Shot-dep.          | .nelem        |                | Number of FE for initial guess of the current distribution                                                                                                                                                         | NELEM              | **10**                      |                                   |
|            | .nolim        |       | If nolim, ignore limiter points when searching LCFS                                                                                                                                                                | 0                    | NOLIM           | NOLIM           | 0                  | .nolim        |                | If nolim, ignore limiter points when searching LCFS                                                                                                                                                                | NOLIM              | 0                           |                                   |
|            | .nr           |       | Number of radial grid points (total: nr+1)                                                                                                                                                                         | 0                    | NR              | NR              | 27                 | .nr           |                | Number of radial grid points (total: nr+1)                                                                                                                                                                         | NR                 | 27                          |                                   |
|            | .nz           |       | Number of vertical grid points (total: 2*nz+1)                                                                                                                                                                     | 32                   | NZ              | NZ              | 32                 | .nz           |                | Number of vertical grid points (total: 2*nz+1)                                                                                                                                                                     | NZ                 | 32                          |                                   |
|            | .plcerr       | [A]   | Error in plasma current measurement                                                                                                                                                                                | +Inf                 | PLCERR          | PLCERR          | 24                 | **.Iperr**    | [A]            | Error in plasma current measurement                                                                                                                                                                                | **IPERR**          | 24                          |                                   |
|            | .plcumin      | [A]   | Minimum plasma current to try a reconstruction                                                                                                                                                                     | 0                    | PLCUMIN         | PLCUMIN         | 1.50E+04           | .plcumin      | [A]            | Minimum plasma current to try a reconstruction                                                                                                                                                                     | **IPMIN**          | 1.50E+04                    |                                   |
|            | .psichco      |       | Convergence criterion on flux                                                                                                                                                                                      | 1.00E-04             | PSICHCO         | PSICHCO         | 5.00E-05           | .psichco      |                | Convergence criterion on flux                                                                                                                                                                                      | PSICHCO            | 5.00E-05                    |                                   |
|            | .robust       |       | If true, fit measurements using robust fitting (requires Statistics and Machine Learning toolbox)                                                                                                                  | FALSE                |                 |                 |                    | .robust       |                | If true, fit measurements using robust fitting (requires Statistics and Machine Learning toolbox)                                                                                                                  |                    |                             | Expert user only                  |
|            | .slx          |       | If true, liu() calls Simulink version liutsim.m                                                                                                                                                                    | 0                    |                 |                 |                    | .slx          |                | If true, liu() calls Simulink version liutsim.m                                                                                                                                                                    |                    |                             | Does not apply to off-line        |
|            | .stab         |       | Proportional gain to stabilize vertical position                                                                                                                                                                   | 1                    | STAB            | STAB            |                    | .stab         |                | Proportional gain to stabilize vertical position                                                                                                                                                                   | STAB               | 1                           |                                   |
|            | .stabint      |       | Integral gain to stabilize vertical position                                                                                                                                                                       | 1                    | STABINT         | STABINT         |                    | .stabint      |                | Integral gain to stabilize vertical position                                                                                                                                                                       | STABINT            | 1                           |                                   |
|            | .stabz        |       | Shift equilibrium to stabilize vertical position                                                                                                                                                                   | 1                    |                 | STABZ           |                    | .stabz        |                | Shift equilibrium to stabilize vertical position                                                                                                                                                                   | STABZ              | 1                           |                                   |
|            | .stabcint     |       | Proportional gain to stabilize vertical position. This should be used only if zfct=liuz0.                                                                                                                          | 1                    |                 |                 |                    | .stabcint     |                | Proportional gain to stabilize vertical position. This should be used only if zfct=liuz0.                                                                                                                          | **STABCINT**       | **1**                       |                                   |
|            | .stabder      |       | Derivative gain to stabilize vertical position. This should be used only if zfct=liuz0.                                                                                                                            | 1                    |                 |                 |                    | .stabder      |                | Derivative gain to stabilize vertical position. This should be used only if zfct=liuz0.                                                                                                                            | **STABDER**        | **1**                       |                                   |
|            | .toflerr      | [Wb]  | Error in diamagnetic flux measurement                                                                                                                                                                              | +Inf                 |                 | TOFLERR         | 1.27E-04           | **.Fterr**    | [Wb]           | Error in diamagnetic flux measurement                                                                                                                                                                              | **FTERR**          | 1.27E-04                    |                                   |
|            | .tolh         |       | Tolerance for FE solver iterations                                                                                                                                                                                 | 0                    |                 |                 |                    | .tolh         |                | Tolerance for FE solver iterations                                                                                                                                                                                 | **TOLH**           | **1.00E-03**                |                                   |
|            | .uc2          |       | if uc2 > 0., LIUQE uses a plasma current measurement derived from the B-probe signals in which the effect of the PF coil currents has been subtracted.                                                             | 1                    | UC2             | UC2             | 1                  | **.wIp**      |                | **Relative weight of plasma current measurements**                                                                                                                                                                 | **WIP**            | **1**                       |                                   |
|            | .uuu          |       | Relative weight of current measurements                                                                                                                                                                            | []                   | UUU             | UUU             | Shot-dep.          | **.wIu**      |                | **Relative weight of vessel current measurements**                                                                                                                                                                 | **WIU**            | **ones(38,1)**              |                                   |
|            |               |       |                                                                                                                                                                                                                    |                      |                 |                 |                    | **.wIa**      |                | **Relative weight of active coil current measurements**                                                                                                                                                            | **WIA**            | **ones(19,1)**              |                                   |
|            | .vvv          |       | Relative weight of B-field measurements                                                                                                                                                                            | []                   | VVV             | VVV             | Shot-dep.          | **.wBm**      |                | Relative weight of B-field measurements                                                                                                                                                                            | **WBM**            | **ones(38,1)**              |                                   |
|            | .www          |       | Relative weight of flux measurements                                                                                                                                                                               | []                   | WWW             | WWW             | Shot-dep.          | **.wFf**      |                | Relative weight of flux measurements                                                                                                                                                                               | **WFF**            | **ones(38,1) exc. 10-12**   |                                   |
|            | .wreg         |       | Weight(s) for current regularization terms.                                                                                                                                                                        | 0                    |                 |                 |                    | .wreg         |                | Weight(s) for current regularization terms.                                                                                                                                                                        | **WREG**           | **2.00E-06**                |                                   |
|            | .wregadapt    |       | Auto-adapt regularization w.r.t. elomin.                                                                                                                                                                           | FALSE                |                 |                 |                    | .wregadapt    |                | Decay rate for regularisation weight with elongation (0 keeps regularisation constant).                                                                                                                            | **WREGADAPT**      | **15**                      |                                   |
|            | .zfct         |       | Vertical position stabilisation function handle.                                                                                                                                                                   | @(P,rst,z0,zA,dz) dz |                 |                 |                    | .zfct         |                | Vertical position stabilisation function handle.                                                                                                                                                                   | **ZFCT**           | **'@(P,rst,z0,zA,dz) dz'**  |                                   |
|            | .z0           |       | Provides user-defined estimate of vertical position. This should be used only if zfct=liuz0.                                                                                                                       |                      |                 |                 |                    | .z0           |                | Provides user-defined estimate of vertical position. This should be used only if zfct=liuz0.                                                                                                                       |                    |                             | TBD                               |
|            |               |       |                                                                                                                                                                                                                    |                      |                 |                 |                    |               |                |                                                                                                                                                                                                                    |                    |                             |                                   |
| TCV        | .ppcs         |       | If ppcs=1,2 or 3, reads parameters from \PCS::TOP.RTLIUQE_1.PARAMETERS                                                                                                                                             |                      |                 |                 |                    | .ppcs         |                | If ppcs=1,2 or 3, reads parameters from \PCS::TOP.RTLIUQE_1.PARAMETERS                                                                                                                                             |                    |                             | Does not apply to off-line        |
|            | .reff         |       | If reff=-1, use 3D flux loops measurements (geometry not implemented yet). Use ideal loop conversion otherwise.                                                                                                    | 0                    |                 |                 |                    | .reff         |                | If reff=-1, use 3D flux loops measurements (geometry not implemented yet). Use ideal loop conversion otherwise.                                                                                                    | **REFF**           | **0**                       |                                   |
|            | .xrtc         |       | If xrtc=1, use signals from RTC tree                                                                                                                                                                               |                      |                 |                 |                    | .xrtc         |                | If xrtc=1, use signals from RTC tree                                                                                                                                                                               |                    |                             | Does not apply to off-line        |
|            |               |       |                                                                                                                                                                                                                    |                      |                 |                 |                    |               |                |                                                                                                                                                                                                                    |                    |                             |                                   |
| PSITBX     |               |       |                                                                                                                                                                                                                    |                      |                 | ITER            | 10                 | .iter         |                | Psitbx: Maximum number of Gauss-Newton iterations for flux-surface description                                                                                                                                     | ITER               | 10                          |                                   |
|            |               |       |                                                                                                                                                                                                                    |                      |                 | NRHG            | 41                 | .nrhg         |                | Psitbx: Number of radial grid points.                                                                                                                                                                              |                    |                             | Psitbx grid must match liuqe grid |
|            |               |       |                                                                                                                                                                                                                    |                      |                 | NTHG            |                    | .nthg         |                | Psitbx: Number of poloidal grid points.                                                                                                                                                                            | NTHG               | 129                         |                                   |
|            |               |       |                                                                                                                                                                                                                    |                      |                 | TOL             | 1e-4               | .tol          |                | Psitbx: Tolerance in distance to magnetic axis for Flux-surface description                                                                                                                                        | TOL                | 1e-4                        |                                   |
|            |               |       |                                                                                                                                                                                                                    |                      |                 |                 |                    |               |                |                                                                                                                                                                                                                    |                    |                             |                                   |
| DEPRECATED | .ibousou      |       | if ibousou=1, flux values on the computational boundary are recomputed at each iteration. if ibousou=0, boundary fluxes are fixed.                                                                                 |                      | IBOUSOU         | IBOUSOU         | 1                  | .ibousou      |                | if ibousou=1, flux values on the computational boundary are recomputed at each iteration. if ibousou=0, boundary fluxes are fixed.                                                                                 |                    |                             |                                   |
|            | .idens        |       | if idens=1, LIUQE looks for line integrated density measurements. This should only be used when ifara=1.                                                                                                           |                      | IDENS           | IDENS           | 0                  | .idens        |                | if idens=1, LIUQE looks for line integrated density measurements. This should only be used when ifara=1.                                                                                                           |                    | 0                           | Could be revived                  |
|            | .ifara        |       | if ifara=1, LIUQE looks for Faraday rotation measurements. This should only be used when idens=1.                                                                                                                  |                      | IFARA           | IFARA           | 0                  | .ifara        |                | if ifara=1, LIUQE looks for Faraday rotation measurements. This should only be used when idens=1.                                                                                                                  | IFARA              | 0                           | Could be revived                  |
|            | .iinv         |       | if iinv>= 2 --> q(0)=1.+float(iinv)/100 if iinv = 1 --> Liuqe reads r,z coordinates of sawtooth inversion points if iinv = 0 --> q(0) is left floating If iinv < 0 --> q(0)=1.+float(iinv)/100                     |                      | IINV            | IINV            | 0                  | .iinv         |                | if iinv>= 2 --> q(0)=1.+float(iinv)/100 if iinv = 1 --> Liuqe reads r,z coordinates of sawtooth inversion points if iinv = 0 --> q(0) is left floating If iinv < 0 --> q(0)=1.+float(iinv)/100                     | IINV               | 0                           | Could be revived                  |
|            | .ipolarimetry |       |                                                                                                                                                                                                                    |                      | IPOLARIMETRY    | IPOLARIMETRY    | 0                  | .ipolarimetry |                |                                                                                                                                                                                                                    | IPOLARIMETRY       | 0                           | Could be revived                  |
|            | .ipres        |       | if ipres=1, LIUQE looks for pressure measurements. In this case the LIUQE times coincide with the Thomson times.                                                                                                   |                      | IPRES           | IPRES           | 0                  | .ipres        |                | if ipres=1, LIUQE looks for pressure measurements. In this case the LIUQE times coincide with the Thomson times.                                                                                                   | IPRES              | 0                           | Could be revived                  |
|            | .mei          |       | number of values in tables of elliptic integrals, to be used for fast evaluation of Green's functions.                                                                                                             |                      | MEI             | MEI             | 16000              | .mei          |                | number of values in tables of elliptic integrals, to be used for fast evaluation of Green's functions.                                                                                                             |                    |                             |                                   |
|            | .ncosei       |       | number of terms used in the azimuthal integral for calculating Green's functions.                                                                                                                                  |                      | NCOSEI          | NCOSEI          | 200                | .ncosei       |                | number of terms used in the azimuthal integral for calculating Green's functions.                                                                                                                                  |                    |                             |                                   |
|            | .ncufit       |       | number of currents to be fitted by LIUQE. This includes currents in 38 vessel elements, 8 E-coils, 8 F-coils, and 2 OH-coils.                                                                                      |                      | NCUFIT          | NCUFIT          | 56                 | .ncufit       |                | number of currents to be fitted by LIUQE. This includes currents in 38 vessel elements, 8 E-coils, 8 F-coils, and 2 OH-coils.                                                                                      |                    |                             |                                   |
|            | .nlimi        |       | number of limiter points used in defining the last closed flux surface. When the belt limiter was installed, nlimi was 81. Now, nlimi is 76.                                                                       |                      | NLIMI           | NLIMI           | 76                 | .nlimi        |                | number of limiter points used in defining the last closed flux surface. When the belt limiter was installed, nlimi was 81. Now, nlimi is 76.                                                                       |                    |                             |                                   |
|            | .npsi         |       | number of flux surfaces at which flux-dependent quantities are evaluated.                                                                                                                                          |                      | NPSI            | NPSI            | 50                 | .npsi         |                | number of flux surfaces at which flux-dependent quantities are evaluated.                                                                                                                                          |                    |                             |                                   |
|            | .psirat       |       | ratio of polodal flux inside plasma boundary to poloidal flux inside separatrix. This parameter is usually set slightly less than 1.0 to avoid the appearance of a "last closed flux surface" which is not closed. |                      | PSIRAT          | PSIRAT          | 0.999              | .psirat       |                | ratio of polodal flux inside plasma boundary to poloidal flux inside separatrix. This parameter is usually set slightly less than 1.0 to avoid the appearance of a "last closed flux surface" which is not closed. |                    |                             |                                   |
|            | .uc1          |       | if uc1 > 0., LIUQE looks for an independent plasma current measurement.                                                                                                                                            |                      | UC1             | UC1             | 0                  | .Ipmeas       |                | if Ipmeas=1, LIUQE looks for an independent plasma current measurement.                                                                                                                                            | IPMEAS             | 0                           | Could be revived                  |
