function Co = LX2Co(L,LX)
% Extract and pack Co from LX structure. 
% Co contains all fields listed in L.agconc
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
Co = zeros(L.ng,numel(LX.t)); 
for iC=1:L.nC
  ii = L.agconc{iC,4};
  myfield = L.agconc{iC,3}; % field and index for this constraint
  assert(isfield(LX,myfield), 'Request constraint %s not available in input LX structure', myfield);
  Co(iC,:) = LX.(myfield)(ii,:);
end
end