function X = liuxtcv_IDS( L, P,IDS_inputs)
% The measurements are extracted just the in the timeslices when equilibrium computation is requested
% All data in X will have homogeneous time grid
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
X.t    = P.t; % vector of time steps when computing the equilibrium
nt     = numel(X.t); % number of time steps when computing the equilibrium

%% Magnetics: Flux loop(Ff), Poloidal Magnetic Probes(Bm), Ip(Ip), Toroidal Flux(Ft)
% Find index for the manetics
time_index_Ff = zeros( L.G.nf, nt);
time_index_Bm = zeros( L.G.nm, nt);
time_index_Ip =  zeros(1, nt);
time_index_Ft =  zeros(1, nt);
if IDS_inputs.magnetics.ids_properties.homogeneous_time == 1
  % All the magnetics has the same time grid
  time_indices_all_magnetics   = zeros(1, nt);
  % Every magnetic will have a different time grid
  for tt=1:nt
    [~, time_indices_all_magnetics(tt) ] = min( abs(X.t(tt) -  IDS_inputs.magnetics.time ));
  end
  for ii=1:L.G.nf
    time_index_Ff(ii,:) = time_indices_all_magnetics;    
  end
  for ii=1:L.G.nm
    time_index_Bm(ii, :) = time_indices_all_magnetics;
  end
  time_index_Ip = time_indices_all_magnetics;
  time_index_Ft = time_indices_all_magnetics;
else
  % Every magnetic will have a different time grid
  for tt=1:nt
    for ii=1:L.G.nf
      [~, time_index_Ff( ii, tt) ] = min( abs(X.t(tt) -  IDS_inputs.magnetics.flux_loop{ii}.flux.time ));
    end
    
    for ii=1:L.G.nm
      [~, time_index_Bm( ii, tt) ] = min( abs(X.t(tt) - IDS_inputs.magnetics.bpol_probe{ii}.field.time  ));
    end
    [~, time_index_Ip(tt) ] = min( abs(X.t(tt) -  IDS_inputs.magnetics.method{1}.ip.time ));
    [~, time_index_Ft(tt) ] = min( abs(X.t(tt) -  IDS_inputs.magnetics.method{1}.diamagnetic_flux.time ));
  end
end

% Flux loop flux
X.Ff = zeros( L.G.nf , nt); %need to check the units are the same
for ii = 1:L.G.nf
  X.Ff(ii,:) = IDS_inputs.magnetics.flux_loop{ii}.flux.data(time_index_Ff(ii,:));
end

% Magnetic poloidal probes
X.Bm = zeros( L.G.nm , nt); %need to check the units are the same
for ii = 1:L.G.nf
  X.Bm(ii,:) = IDS_inputs.magnetics.bpol_probe{ii}.field.data(time_index_Bm(ii,:));
end

% --------------------------------------------------------------------------
% --------- This could change at certain point depending on the definition of method
% ---------------------------------------------------------------------------
% Can be computed from discrete Rogowsky 
% X.Ip   = L.Ipm*X.Bm + L.Ipa*X.Ia - L.Ips./L.G.Rs(:)'*X.Uf; 
% Taken from the data if available
% Ip
X.Ip = zeros(1, nt);
X.Ip =  IDS_inputs.magnetics.method{1}.ip.data(time_index_Ip);

% Toroidal flux, diamagnetic flux loop
X.Ft = zeros(1, nt);
X.Ft =  IDS_inputs.magnetics.method{1}.diamagnetic_flux.data(time_index_Ft);


%% pf_active
time_index_Ia = zeros( L.G.na, nt);
if  IDS_inputs.pf_active.ids_properties.homogeneous_time 
  % All the magnetics has the same time grid
  time_indices_all_pf_active   = zeros(1, nt);
  % Every magnetic will have a different time grid
  for tt=1:nt
    [~, time_indices_all_pf_active(tt) ] = min( abs(X.t(tt) -  IDS_inputs.pf_active.time ));
  end

  for ii =1:L.G.na
    time_index_Ia(ii,:) = time_indices_all_pf_active;
  end
else
  for tt = 1:nt
    for ii=1:L.G.na
      [~, time_index_Ia( ii, tt) ] = min( abs(X.t(tt) - IDS_inputs.pf_active.coil{ii}.current.time  ));
    end
  end
end

X.Ia =  zeros(L.G.na, nt);
for ii=1:L.G.na
  X.Ia(ii,:) = IDS_inputs.pf_active.coil{ii}.current.data(time_index_Ia(ii,:));
end

%% tf (toroidal field)
time_index_rBt = zeros(1, nt);
if  IDS_inputs.tf.ids_properties.homogeneous_time
  % All the magnetics has the same time grid
  time_indices_all_tf   = zeros(1, nt);
  % Every magnetic will have a different time grid
  for tt=1:nt
    [~, time_indices_all_tf(tt) ] = min( abs(X.t(tt) -  IDS_inputs.tf.time ));
  end
    time_index_rBt = time_indices_all_tf;
else
  for tt = 1:nt
      [~, time_index_tf(tt) ] = min( abs(X.t(tt) - IDS_inputs.tf.b_field_tor_vacuum_r.time  ));
  end
end

X.rBt =  zeros(1, nt);
X.rBt = IDS_inputs.tf.b_field_tor_vacuum_r.time(time_index_tf);

%% Temporarly to evaluate the vloop
% ---------------------  Temporarly to evaluate the vloop ------------- %
% the the Uf of the coil. Ff is the integral of Uf, with an analog
% integration so it has to be intended as an independent measurement.
% ------------------------------------------------------------------ %

%It is too big to upload the pf systems to get all the time. Once it will
%be possible one can use this code to evaluate the derivative

% dimension = numel(T);
% data = zeros(dimension,38);
% for ii=1:dimension
%     data(ii,:) = [magdiag(ii).flux_loops.measure.value]; % getting just the measurements for the Ff all the time series
% end
% [~,X.Uf] = interpos(X.t, data, X.t,-200); % Evaluate Uf = d Ff/ dt with a spline interpolation
% Check if it is a block description of the wall or anular
if strcmp( 'annular', strtrim(P.wall_type))
  X.Uf = zeros( L.G.nf , nt); 
  for ii = 1:L.G.nf
    X.Uf(ii,:) = interpos(X.t, X.Ff, X.t,-200);
  end
  X.Is  = bsxfun(@rdivide,X.Uf,-L.G.Rs(:));

elseif strcmp( 'block', strtrim(P.wall_type))
  % TODO the implementation for the block type
  error('Unable to compute vessel current')
elseif strcmp( 'none', strtrim(P.wall_type))
  X.Is = zeros(0,nt);
end




end

