function [L,LX,LY] = liu_IDS(pf_active, pf_passive, magnetics,tf, wall,run_time_slices,parameters, varargin)
% Change the way the path are addxs
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
cd /afs/eufus.eu/g2itmdev/user/g2fracar/Public/trunk
addpath(genpath('/afs/eufus.eu/g2itmdev/user/g2fracar/Public/crpptbx'))
addpath(genpath('./'))
addpath('/afs/eufus.eu/g2itmdev/user/g2osaute/public/matlab')

IDS_inputs = struct();
IDS_inputs.pf_active = pf_active ;
IDS_inputs.pf_passive = pf_passive ;
IDS_inputs.magnetics = magnetics;
IDS_inputs.tf = tf;
IDS_inputs.run_time_slices = run_time_slices;
IDS_inputs.wall = wall;
IDS_inputs.parameters = parameters;


% Parameters and checking
P =       liup_IDS(IDS_inputs, varargin{:});
P.t = run_time_slices;

% Ancillary data and geometry
L = liuc(P, liugtcv_IDS(P, IDS_inputs) );

if nargout > 1 && nargin > 1 && ~isempty(P.t)
  % LIUQE measurements
  LX = liuxtcv_IDS(L,P, IDS_inputs);
  if nargout > 2
    % LIUQE reconstruction
    LY = liut_CPO(L,LX, 'debug',1);
  end
end

