# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## Unreleased

- !556: Enforce stricly positive number of basis functions
- !552: FGE non-convergence recovery logic - Keep previous timestep
- !555: Add experimental support for Octave
- !553: flcs - Fix unconstrained number of threads in calls to bspsum/bsp2deval
- !550: fbtptcv - Suppress undesired output

## [5.0.0] - 2023-01-16

- !548: Makefile - Enable Windows build
- !545: fbtptcv - update algorithm providing guess for gpb value of legacy control points
- !546: Enable time-varying gpdw in FBT
- !544: Refactor post-processing and add [r|z,r|z,max|min]
- !307: Add R,Z,Ip + coil feedback controllers
- !542: Updates to lih and field post-processing
- !543: fget - Fix bug in consecutive non-converged time steps counter
- !541: Export MEQ results to G-EQDSK file format
- !539: Reuse LX data when possible in rzp tests
- !540: mexargs - implement checks of numeric type for scalar inputs of MEX-files
- !538: Correctly reuse binaries from other build jobs in CI job publishing documentation
- !521: Implement cubic spline interpolation for identification of limiter/X points and FS contours
- !536: Introduce G.Dda to make FBT Dax (current dipole matrix) customizable
- !537: Minor genlib and makefile-related updates
- !533: Restore solveF behaviour difference for cgs/mgs
- !531: Cleanup FBT parameters, add meqx and fbtxtok
- !530: Eleven FBT equilibria for Anamak + fbtxplot/fbtplot
- !528: Add fbtxdisp and improve fbt help
- !523: Refactor Arnoldi Iterations in solveF.m
- !506: Minor miscellaneous fixes
- !527: Improve fbt fitting error reporting
- !516: update meqxconvert to return minimal liu inputs
- !526: Add copyright headers to all files
- !525: Add check for help header presence in meqhelp test, add Ini to fget help
- !524: solveF - use the same inner residual tolerance for all Gram-Schmidt methods
- !522: meqwtcv - Store flux with F=0 at R=0 convention for doublets
- !519: asxy - refactor interpolation of flux in both C and MATLAB sources
- !520: Change boundary condition of radial spline, improves accuracy of metric coefficients at the edge
- !513: Introduce Picard plasma convergence loop for FGS/FGE solvers
- !517: Clarify use of integer types in C source files
- !505: Add checks for C MEX-file arguments using the mexargs project via genlib
- !510: Minor visualization improvements
- !509: Allow FBT to run without vessel definition
- !508: Improve documentation related to coordinate systems
- !515: CI config syntax switch to rules instead of only/except
- !507: Improve meqgsave/meqgload
- !504: Add tool for converting polygon vessel description into filaments

## [4.5.2] - 2022-07-11

- !503: Enforce using the latest static tree version when preparing the MODEL shot with FBT
- !501: Change fbtt residual definition to match liut's and better handle quadprog failures
- !500: Fix bug when removing inequality constraints in fbtt
- !499: Add calculation of B*za/B*zu matrices in meqg
- !498: Fix bug in `dFdI` preventing `fgel` calls with `nu<3`
- !475: Add fast rzip version for RT use
- !497: Fix mds2meq when retrieving FBTE.M data
- !496: Update to latest SPC CI template
- !495: Generate HTML code coverage reports and archive them for released versions only
- !492: Fix Makefile dependencies for published documentation, run parallel make for CI builds
- !493: Enable choosing TCV static tree version via new parameter 'static'
- !491: Allow default time selection in liu(tok='TCV')
- !490: Fix tests of computation of B field
- !487: Extend default x grid 1/2 cell beyond limiter
- !484: Change liutslx.slx to look for `configurationSettings` in base workspace
- !488: Various `Makefile` updates
- !485: Check for `genlib` presence in `meqg.m`
- !482: Fixes for running LIUQE on old TCV shots 
- !481: Implement tests for ipm.m and fix ipm mode=1,5
- !480: Improve scaling of quadprog problems in FBT
- !470: Skip FGS calculation at initialization of RZP
- !478: Fix publish-documentation job conditions

## [4.5.1] - 2022-04-01

- !368: First tutorial and automated publishing of html documentation
- !469: Further minor `CHANGELOG.md` fix
- !468: Missing `CHANGELOG.md` fixes
- !472: Fix meqxconvert bug to conserve sum(Iy(:)) upon grid change
- !473: Change SPC CI build tags
- !464: Add more documentation to top-level functions

## [4.5.0] - 2022-02-02

- !466: Add meqreprocess
- !461: Compute Br,Bz for various grids as part of `meqpost` and change `P.fancyplot` to `P.izgrid`
- !400: Add rzp rigid-body plasma + conductor current model
- !465: Minor clean up of SCD interface

## [4.4.2] - 2021-12-21

- !463: Hotfix to change `get_scd_mems` calls following update of SCD toolbox

## [4.4.1] - 2021-12-17

- !460: Miscellaneous fixes to `meqplotfancy`, `mds2meq` and `liusimc`
- !459: Fix interpolation to compute q95 in `meqpostq`.
- !458: Minor correction to meqt.m documentation for aminor

## [4.4.0] - 2021-11-29

- !455: Add option to get default parameter values for TCV liu run.
- !454: Generalize use of liut with a custom initial guess.
- !452: Fix Q4Q unit in meqt.m
- !451: For TCV give precedence to `selx` in choice of `X` grid.
- !450: Remove circular dependencies between P and G structures. 
- !435: Move loading of `dz`-related G quantities from `meqgtcv` to `liugtcv`
- !449: Add size checks for arguments of asxymex to avoid exceptions
- !448: Fix bug where fetype='bil' FE always extended to the edge of the grid
- !447: Fix bug where zl parameter was ignored in liu for TCV
- !445: Update description of output quantities in `meqt.m` and update meqhelp_test
- !446: Cleanup bfct,bfp defaults and bugs thereby exposed 
- !443: Make use of genlib subdirectory optional in `meq_fixture`.
- !441: Add option to get the spatial derivatives of the magnetic field created by the external currents in `meqg`
- !442: Fix FBT parameters initialization for TCV shots prior to 56469 where `gp*` parameters are not stored

## [4.3.0] - 2021-10-05

- !440: Fix HTML code coverage report generation and publication
- !439: Fix deployment pipelines following code coverage additions
- !436: Various improvements to LIUQE output and plotting for plasma-less slices
- !437: Add meqplotfull.m plotting function
- !434: Remove SCD folder paths since now deployed on lac crpptbx
- !433: Minor meqgplot cleanups
- !432: Update documentation of the radial grid parameters
- !430: Fix tests with missing TestTags
- !431: Fix CI pipeline to generate and publish HTML code coverage report
- !428: Add CI job to merge code coverage reports and provide metric to GitLab
- !429: Fix broken path to SCD tools
- !338: Generate code coverage reports as CI job artifacts
- !427: Refactor `asxy` to reduce code duplication (#239)
- !426: Fix compilation with debug information (#484), add BUILD option to Makefile
- !425: Fix bug where `lasy` parameter to identify X-points outside of limiter was ineffective

## [4.2.4] - 2021-09-10

- !423: Fix bug in asxy where null points estimates could end up too far from the original cell (#231)
- !422: Fix bug in asxy where 2 axes were identified in cells with equal center values (#245)
- !421: In FBT if solution without inequality constraints enforced satisfies them then keep it

## [4.2.3] - 2021-08-30

- !419: Allow FBT and LIU to return LY containing converged and failed slices
- !413: Refactor `meqg.m` for compactness and efficiency
- !414: remove `try/catch`, better condition `fbt` LSQ problem and use `quadprog`
- !418: Fix small mds2meq bug for RTLIUQE case
- !412: Add meqgsave/meqgload for geometry saving/loading
- !411: Fix CHANGELOG omission of !397 for v4.2.2

## [4.2.2] - 2021-07-18

- !408: Fix minor bug in meqsk related to nan padding size
- !409: Fix plotting bug preventing meqplott plotting of multiple FW in some cases
- !387: Extend fgess to include linearization w.r.t. constraints and CDE
- !405: Fix bug in `meqFx` when `IyD` was only zeroes. Add parameter to allow current holes.
- !404: Fix currently opened tree bug in `mds2meq`.
- !401: Improved CREATE geometry/vessel description and plotting
- !397: Fix bug related to scaling of FGE preconditioner
- !396: Fix bug where liut debug fails when called on first iteration
- !395: Enable storing of `LY.Vp` in `VOL_PL` node in `meqwtcv.m`.
- !394: Fix bug where shot was not stored correctly in `L` and `LX` for `tok='ana'`
- !392: Re-add Is (segment current) as output

## [4.2.1] - 2021-06-01

- !389: Minor FGE/FGS/FBT shot and time handling cleanups

## [4.2.0] - 2021-05-17

- !385: Retroactively fix and update CHANGELOG.md
- !381: Disentangle `meqpdom` mode parameters and add optional quadratic interpolation on limiter
- !382: Minor cosmetics and cleanups
- !365: Fix name of `shap` block outputs.
- !379: Add p>0 constraint in liuqe Simulink version.
- !377: Remove option to run `gszr` with empty `Fb` to set zero boudary condition (Follow up of !355).
- !373: Add nFW>1 case in Simulink and anamak shot 6 to better test it.
- !378: Fix version requirements for `mkcsf`, R2019a or later is now required.
- !372: Updates to bring into SCD2021 operation
- !376: Fix scale of `PpQ/TTpQ` in `mds2meq` for `source='FBTE'` when `FBTE.M` was used.
- !371: Improved slx/sldd and Simulink configuration handling, move Simulink to R2019a, unify lih/liusimc.
- !370: Better defaults and checks for bfp.
- !369: Improved FBT points for Anamak shot 4 (double null).
- !360: Updates related to reading SCD and other data
- !367: Fix condition for using preconditioner in case of multiple equilibria for `FGS`.
- !366: Fix uncaught mkmeqh/mkcsf errors in Makefile.
- !361: Fix uninitialized Fx variable in `gszr` causing problems in LIUQERT runs.
- !355: Fix bug where sign of Ip could be zero in Simulink model.
- !354: Update genlib version, for improved `greenem` accuracy for close loops.
- !352: Minor .gitlab-ci.yml improvements.
- !351: Fix source of LIUQE parameters in `mds2meq`.

## [4.1.0] - 2021-03-30

- !348: Provide complete `L` structure as output of `mds2meq` for TCV shots.
- !347: Fix FGS initial guess from input `LX` structure.
- !334: Implement `OhmTor/OhmTor_rigid` options for FGE current diffusion equation based on Ohm's law toroidal projection.
- !346: Add CHANGELOG.md file
- !344: When loading legacy FBT parameters for TCV shots, discard control points for strike points from plasma initial guess.
- !342: Remove persistent variables in `liut`. Use `IyD` as state variable in liutnwt.
- !341: Small fix in `meqxconvert`.
- !337: Cleanup SLDD handling in `liusimc/lihsimc`. Change dummy time handling.
- !336: For TCV shots, FBT loads additional parameters from the `\mgams:debug:p1` node.
- !335: Fix bug in `fgex` where signeo was overwritten by `fgeinit`.
- !332: New parameter `ipmeas` to use independent Ip measurement in liuqe, treat this correctly in `liusim`.
- !331: Allow `liusim` to run when no external conductors are in the computational grid.
- !330: Make help section of `mexm` files uniform.
- !327: In `rtci`, avoid points crossing domain boundaries.
- !328: Fork `fsgimexm` from `fsgimex` and add tests.
- !329: Add tests for `gszrmexm`.
- !302: In `liuxtcv`, load power supply voltages and clean test for time compatibility.
- !322: Treat correctly circular windings in `meqg`.
- !321: Correct inductive coil direction for FGE initial state.
- !319: Add coupling between DML and plasma current in `liusim`.
- !317: Add `limm` parameter in FBT for introducing a margin with respect to the different coil current limits.
- !318: In the test suite, create a separate `meq_simulink_fixture` to be used with Simulink tests only.
- !315: Set default value of `iters` to 48 for liuqe's iterative solver.
- !314: Fix plasma domains extending past the limiter for single axis cases.
- !312: Fix FBT discarding `gp*` variables for TCV model shot.

## [4.0.1] - 2021-02-09

- !310: Use EQUIL parameter tree by default on TCV for LIUQE. Finalize `.gitlab-ci.yml` settings for deployment.

## [4.0.0] - 2021-02-09

First release since move to Gitlab and first release at TCV since July 2018.
