% make_mdsipmex2020
% make sure ../mdsplus points to current version of mdsplus distribution
% Basil P. DUVAL, June 2020- Clean up to 2020 version (D_types and socket io)
% use matlab variables ( must have shell variable MDSPLUS pointing to sources)
% debug=1;	% Make debug clauses in code work
% shared=1;	% shareable version (allows ssh://user@server protocols)
% dynamic=1;	% Shareables links are performed at runtime (implies shared)
% local=1;	% allows local connections (implies shared too)
%
% clear all;setenv('MDSPLUS','./mdsplus');make_mdsipmex2020
% !mv mdsipmex.mexa64  mdsipmex.mexa64-static
% clear all;setenv('MDSPLUS','/usr/local/mdsplus');dynamic=1;local=1;shared=1;make_mdsipmex2020
% !mv mdsipmex.mexa64  mdsipmex.mexa64-shared

% tar cvfz mdsbin.tar.gz -T FilesTar

%* LOCAL_CONNECT        Allow mdsconnect('local')- requires shareable libraries
%* SHARED               Link to shared version- different connect calls
%* DYNAMICLINK          Libraries resolved at runtime- implicitly MDSLIBS
 
% -DNOPTHREAD used by windows
% -DUSE_MDSLIB_H used by shareable Linux bhosttoip routine

MDSPLUS=getenv('MDSPLUS');
links='';
DEBUG='';
BLOCAL='';

if ~exist('debug'  ,'var'), debug   = false; end
if ~exist('shared' ,'var'), shared  = false; end
if ~exist('dynamic','var'), dynamic = false; end
if ~exist('local'  ,'var'), local   = false; end
if ~exist('timeout','var'), timeout = false; end

%Check id MDSPLUS shell variable was given
if isempty(MDSPLUS) % Linux requires that MDSPLUS/MDSPLUS_DIR was given
  if ispc % Windows
    MDSPLUS=[pwd,'/mdsplus'];
  else    % UNIX
    MDSPLUS=getenv('MDSPLUS_DIR');
    if isempty(MDSPLUS)
      disp('shell variable MDSPLUS or MDSPLUS_DIR must point to MDSplus distribution before compilation');
      return
    end
  end
end

if ispc % Windows version
  links='-lws2_32';
  DEBUG='-compatibleArrayDims -DNOPTHREAD ';
else    % UNIX version
  DEBUG='';
end
if debug, DEBUG = ['-DDEBUG -g -v ',DEBUG];end

if dynamic
  shared=1; % Libs are dynamic, so there are libs
  BLIBS='-DDYNAMICLINK';
else
  BLIBS=sprintf('-L%s/lib -lMdsIpShr',MDSPLUS);
  % local, without dynamic, requires libTdiShr and libMdsShr
  if local, BLIBS=[BLIBS,' -lTdiShr -lMdsShr']; end
end

% allow local connections
if local
  BLOCAL='-DLOCAL_CONNECT';
  shared=1;
end

if shared
  BLIBS = ['-DSHARED ',BLIBS];
end

if dynamic
  BLIBS = [BLIBS,' -ldl'];  % Tack on dynamic link (only for dynamic loading I believe?)
end

if shared && verLessThan('matlab','9.2')
  BLIBS = [BLIBS, ' CFLAGS=''$CFLAGS -std=c99'''];
end

if ~timeout
  DEBUG = [DEBUG,' -DNOGETANSWERINFOTO'];
end

% Simulate password routine in code
if (~strcmp(computer,'VMS'))
  PASSWD = '-DPASSWD';
else
  PASSWD = 'mdsipmex.opt';
end

%First list routines to be linked in StaticLink mode
if ~shared
  r={'mdsipshr.c','mdsiputil.c','adler32.c','compress.c','deflate.c','infblock.c','infcodes.c',...
     'inffast.c','inflate.c','inftrees.c','infutil.c','trees.c','uncompr.c','zutil.c','mdsip_socket_io.c'};
  comm = sprintf('mex %s %s mdsipmex.c -I%s/include -I%s/mdstcpip %s',...
                 DEBUG,PASSWD,MDSPLUS,MDSPLUS,links);
  % add all the routines using the given path
  for(i=1:length(r))
    comm = sprintf('%s %s/mdstcpip/%s',comm,MDSPLUS,char(r(i)));
  end
else
  if ispc % For windows shared version
    comm = sprintf('mex  %s %s mdsipmex.c -I"%s/include" -I"%s/mdstcpip" -L"%s/devtools/mingw/lib64" -lMdsIpShr %s',...
                   DEBUG,PASSWD,MDSPLUS,MDSPLUS,MDSPLUS,links);
  else   % For Linux shared version
    comm = sprintf('mex %s %s mdsipmex.c -I%s/include -I%s/mdstcpip %s %s',...
                    DEBUG,PASSWD,MDSPLUS,MDSPLUS,BLOCAL,BLIBS);
  end
end
disp(comm);eval(comm);
